﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/detail/core/timesrv_StandardNetworkSystemClockCore.h>
#include <nn/timesrv/detail/core/timesrv_SteadyClockCore.h>
#include <nn/time/detail/util/time_UtilApi.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

StandardNetworkSystemClockCore::StandardNetworkSystemClockCore(SteadyClockCore* pSteadyClockCore) NN_NOEXCEPT
    : SystemClockCore(pSteadyClockCore)
    , SufficientAccuracyThreshold(nn::TimeSpan::FromDays(10))
{
}

StandardNetworkSystemClockCore::~StandardNetworkSystemClockCore() NN_NOEXCEPT
{
}

void StandardNetworkSystemClockCore::SetSufficientAccuracyThreshold(const nn::TimeSpan& threshold) NN_NOEXCEPT
{
    SufficientAccuracyThreshold = threshold;
}

nn::TimeSpan StandardNetworkSystemClockCore::GetSufficientAccuracyThreshold() const NN_NOEXCEPT
{
    return SufficientAccuracyThreshold;
}

bool StandardNetworkSystemClockCore::IsStandardNetworkSystemClockAccuracySufficient() const NN_NOEXCEPT
{
    nn::time::SteadyClockTimePoint timePoint;
    NN_RESULT_DO(GetSteadyClockCore().GetCurrentTimePoint(&timePoint));

    int64_t elapsedSeconds;
    auto result = nn::time::detail::util::GetSpanBetween(&elapsedSeconds, m_SystemClockContext.timeStamp, timePoint);

    if (result.IsSuccess() && nn::TimeSpan::FromSeconds(elapsedSeconds) < SufficientAccuracyThreshold)
    {
        return true;
    }

    return false;
}

}
}
}
}

