﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_ApiForEnsureNetworkClockAvailability.h>
#include <nn/ntc/ntc_EnsureNetworkClockAvailabilityMode.h>
#include <nn/ntc/shim/ntc_Shim.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

#include <new>

namespace nn { namespace time {

Result EnsureNetworkClockAvailability() NN_NOEXCEPT
{
    return nn::ntc::shim::EnsureNetworkClockAvailability();
}

void CancelEnsuringNetworkClockAvailability() NN_NOEXCEPT
{
    nn::ntc::shim::CancelEnsuringNetworkClockAvailability();
}

//
// AsyncEnsureNetworkClockAvailabilityTask ---------------------------
//

#define NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR (reinterpret_cast<nn::ntc::shim::CorrectionNetworkClockAsyncTask*>(&m_Storage))

#define NN_TIME_ASYNC_ENSURE_CLIENT_REQUIRE_INITIALIZE NN_SDK_REQUIRES(m_IsInitialized, "nn::time::AsyncEnsureNetworkClockAvailabilityTask::Initialize is not called.")

AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask() NN_NOEXCEPT:
    m_IsInitialized(false)
{
    NN_STATIC_ASSERT(sizeof(StorageType) >= sizeof(nn::ntc::shim::CorrectionNetworkClockAsyncTask));
    NN_STATIC_ASSERT(NN_ALIGNOF(StorageType) % NN_ALIGNOF(nn::ntc::shim::CorrectionNetworkClockAsyncTask) == 0);

    std::memset(&m_Storage, 0, sizeof(m_Storage));
}

AsyncEnsureNetworkClockAvailabilityTask::~AsyncEnsureNetworkClockAvailabilityTask() NN_NOEXCEPT
{
    if (m_IsInitialized)
    {
        NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR->~CorrectionNetworkClockAsyncTask();
    }
}

void AsyncEnsureNetworkClockAvailabilityTask::Initialize(nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
{
    if(!m_IsInitialized)
    {
        new(&m_Storage) nn::ntc::shim::CorrectionNetworkClockAsyncTask(eventClearMode, nn::ntc::EnsureNetworkClockAvailabilityMode_Default);

        m_IsInitialized = true;
    }
}

nn::Result AsyncEnsureNetworkClockAvailabilityTask::StartTask() NN_NOEXCEPT
{
    NN_TIME_ASYNC_ENSURE_CLIENT_REQUIRE_INITIALIZE;
    return NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR->StartTask();
}

nn::Result AsyncEnsureNetworkClockAvailabilityTask::GetResult() NN_NOEXCEPT
{
    NN_TIME_ASYNC_ENSURE_CLIENT_REQUIRE_INITIALIZE;
    return NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR->GetResult();
}

nn::os::SystemEvent& AsyncEnsureNetworkClockAvailabilityTask::GetFinishEvent() NN_NOEXCEPT
{
    NN_TIME_ASYNC_ENSURE_CLIENT_REQUIRE_INITIALIZE;
    return NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR->GetFinishNotificationEvent();
}

void AsyncEnsureNetworkClockAvailabilityTask::Cancel() NN_NOEXCEPT
{
    NN_TIME_ASYNC_ENSURE_CLIENT_REQUIRE_INITIALIZE;
    return NN_TIME_ASYNC_ENSURE_CLIENT_GET_IMPL_PTR->Cancel();
}

}} // nn::time

