﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/tcap/detail/tcap_Log.h>

#include "tcap_FirmwareDebugSettingsAccessor.h"

namespace nn { namespace tcap { namespace server {

class SettingsHolder final
{
    NN_DISALLOW_COPY(SettingsHolder);
    NN_DISALLOW_MOVE(SettingsHolder);

public:
    SettingsHolder() NN_NOEXCEPT;

    //! settings から設定を取得します。
    void LoadSettings() NN_NOEXCEPT;

    //! ContinuousHighSkinTemperature イベントをシグナルするまでの時間をミリ秒で取得します。@n
    //! GetTimeToSignalContinuousHighSkinTemperatureEventMilliSeconds にしたかったのですが長いので却下しました。
    int GetContinuousHighSkinTemperatureMilliSeconds() NN_NOEXCEPT;

    bool IsThermalBurnPreventionModeEnabled() NN_NOEXCEPT;

private:
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pKey) NN_NOEXCEPT
    {
        m_FirmwareDebugSettingsAccessor.ReadSetting(pOutValue, pKey);
        NN_DETAIL_TCAP_TRACE("%s : %d\n", pKey, *pOutValue);
    }

private:
    //! ContinuousHighSkinTemperature イベントをシグナルするまでの時間です。
    int m_ContinuousHighSkinTemperatureMilliSeconds;

    bool m_ThermalBurnPreventionModeEnabled;

    //! 設定値へのアクセサです。
    FirmwareDebugSettingsAccessor m_FirmwareDebugSettingsAccessor;
};

}}} // namespace nn::tcap::server
