﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/fan/fan.h>
#include <nn/tc/tc_Types.h>
#include <nn/tc/impl/tc_PowerModeTypes.h>

namespace nn { namespace tc { namespace impl { namespace detail {

void InitializeAdvancedPolicy() NN_NOEXCEPT;
void FinalizeAdvancedPolicy() NN_NOEXCEPT;
nn::fan::RotationSpeedLevel GetRotationSpeedLevelFromAdvancedPolicy(TemperatureMilliC skinTemperature, TemperatureMilliC pcbTemperature, TemperatureMilliC socTemperature) NN_NOEXCEPT;
void SetOperatingModeToAdvancedPolicy(OperatingMode operatingMode) NN_NOEXCEPT;
void SetPowerModeToAdvancedPolicy(PowerMode powerMode) NN_NOEXCEPT;

}}}} // namespace nn::tc::impl::detail
