﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace nn { namespace ssl { namespace detail {

class NssConfigFsManagerBase
{
public:
    static const char*                    g_MountPrefix;
    static const uint32_t                 g_MountPathStringLength = 256;
    static const nn::fs::SystemSaveDataId g_SslSystemSaveId       = 0x8000000000000060L;
    static const nn::fs::SaveDataFlags    g_SaveDataFlag          = static_cast<nn::fs::SaveDataFlags>(0);
    static const uint64_t                 g_MaxSaveDataSize       = 1024 * 1024 * 32;
    static const uint64_t                 g_SaveDataJournalSize   = 1024 * 1024 * 16;
    static const uint64_t                 g_FsInitMaxRetry        = 3;

    static nn::Result MountHostFs(const char *pMountPathStr);
    static nn::Result UnmountHostFs();
    static nn::Result SetupNssCfgTree(const char *pInPathStr, size_t pathLength);
};

} } }
