﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/ssl_Types.h>
#include <nn/util/util_IntrusiveList.h>
#include "ssl_NssCommon.h"

#define ELEMENT_COUNT_IN_ARRAY(arrayObj) (sizeof(arrayObj) / sizeof(*arrayObj))

namespace nn { namespace ssl { namespace detail {

class EvCertUtil
{
public:
    // --------------------------------------------------------------------------------------------
    // PolicyOidInfo class
    // --------------------------------------------------------------------------------------------
    class PolicyOidInfo
    {
    private:
        SECOidTag* m_pOidsHead;
        size_t     m_oidsCount; //<! The number of OIDs in SECOidTag array (m_pOidsHead)
        size_t     m_listSize;  //<! The size of SECOidTag array (m_pOidsHead)

    public:
        PolicyOidInfo();
        ~PolicyOidInfo();

        nn::Result Setup(size_t oidCount);
        void       Cleanup();
        SECOidTag* GetHead();
        size_t     GetCount();
        nn::Result AddOids(SECOidTag* pInOidHead, size_t count);
        bool       IsOidSet(SECOidTag oid);
    };

    struct OidTagListElement
    {
        nn::util::IntrusiveListNode listNode;
        SECOidTag oidTag;
    };

    typedef nn::util::IntrusiveList<
        OidTagListElement,
        nn::util::IntrusiveListMemberNodeTraits<OidTagListElement, &OidTagListElement::listNode> >
            OidTagListType;

    // --------------------------------------------------------------------------------------------
    // BuiltInPolicyOids class - Database where built-in policy OIDs are stored
    // --------------------------------------------------------------------------------------------
    class BuiltInPolicyOids
    {
    private:
        static OidTagListType g_DataList; //<! The data set where built-in OIDs are stored

    public:
        static nn::Result    Initialize();
        static void          Finalize();
        static size_t        GetCount();
        static nn::Result    GetOidInfo(PolicyOidInfo* pOutOidInfo);
    };

    // --------------------------------------------------------------------------------------------
    // EvCertUtil class static methotds
    // --------------------------------------------------------------------------------------------
    static nn::Result EncodePolicyOidString(SECOidTag* pOutPolicyOid, const char* pInOidString);
    static nn::Result GetErrorDetail(SECErrorCodes* pOutError, PolicyOidInfo* pInOidInfo, CERTCertificate* pInCert);
};

}}}
