﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "detail/ssl_ISslServiceFactoryBase.h"
#include "server/ssl_SslServiceImpl.h"

using namespace nn::sf;
using namespace nn::ssl::sf;

namespace nn { namespace ssl { namespace detail {

typedef ObjectFactory<ExpHeapAllocator::Policy>     SfObjFactory;

class ISslServiceDfcFactory : ISslServiceFactoryBase
{
public:
    nn::Result CreateISslService(SharedPointer<ISslService> *pOut) NN_NOEXCEPT;

};

} } }
