﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/ssl_Types.h>

namespace nn { namespace ssl { namespace detail {

// ------------------------------------------------------------------------------------------------
// BuiltInPolicyOid
// ------------------------------------------------------------------------------------------------
class BuiltInPolicyOid
{
public:
    static const int    Version      = 1;  // The version of built-in policy OID list
    static const size_t MaxOidsCount = 2;  // The maximum count of OIDs per CA cert
    static const size_t MaxOidLength = 32; // The maximum length of an OID string including NULL

#if defined(NN_BUILD_CONFIG_OS_WIN)
// This is for warnings in VS2012/VS2013
#pragma warning (disable : 4510) // default constructor could not be generated
#pragma warning (disable : 4610) // struct can never be instantiated
#endif // NN_BUILD_CONFIG_OS_WIN
    typedef struct Data
    {
        const char policyOids[MaxOidsCount][MaxOidLength];
    } Data;
#if defined(NN_BUILD_CONFIG_OS_WIN)
#pragma warning (default : 4510) // default constructor could not be generated
#pragma warning (default : 4610) // struct can never be instantiated
#endif // NN_BUILD_CONFIG_OS_WIN

    static const Data data[];

private:
    BuiltInPolicyOid(); // Disabling instantiation of this class
};

// ------------------------------------------------------------------------------------------------
// BuiltInPolicyOid: Constants
// ------------------------------------------------------------------------------------------------
const BuiltInPolicyOid::Data BuiltInPolicyOid::data[] = {
    {{"1.3.6.1.4.1.6334.1.100.1",   ""}},                           // Cybertrust
    {{"1.3.6.1.4.1.6449.1.2.1.5.1", ""}},                           // COMODO
    {{"2.16.840.1.114412.2.1",      "2.16.840.1.114412.1.3.0.2"}},  // DigiCert
    {{"2.16.840.1.114028.10.1.2",   ""}},                           // Entrust
    {{"1.3.6.1.4.1.14370.1.6",      ""}},                           // GeoTrust
    {{"1.3.6.1.4.1.4146.1.1",       ""}},                           // GlobalSign
    {{"2.16.840.1.114413.1.7.23.3", "2.16.840.1.114413.1.7.23.1"}}, // Go Daddy
    {{"2.16.840.1.114414.1.7.23.3", "2.16.840.1.114414.1.7.23.1"}}, // Starfield
    {{"2.16.840.1.113733.1.7.48.1", ""}},                           // Thawte
    {{"2.16.840.1.113733.1.7.23.6", ""}},                           // VeriSign
};


}}}

