﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/srepo/detail/service/core/srepo_StateDuration.h>

namespace nn { namespace srepo { namespace detail { namespace service { namespace core {

void GenerateStateDuration(
    StateDuration *pOut,
    const StateChangePoint& changePoint,
    nn::TimeSpanType current) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOut);

    pOut->pStateValue = changePoint.pStateValue;
    pOut->duration = current - changePoint.time;

    if(nn::TimeSpan(pOut->duration) < nn::TimeSpan(0)) // フェイルセーフでマイナスの場合は0に丸める
    {
        NN_SDK_ASSERT(false); // バグ以外では起こらない
        pOut->duration = nn::TimeSpan(0);
    }
}

}}}}}
