﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>

#include "spsm_IEventHandler.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  ThermalCoordinatorAdvancedPolicy 監視用クラス
//  ThermalCoordinatorAdvancedPolicy から送られてくる温度異常のイベントを監視する
//
class ThermalCoordinatorAdvancedPolicy final : public IEventHandler
{
public:
    void Initialize(::nn::spsm::server::PowerStateMessageQueue*) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void LinkMultiWaitHolders(::nn::os::MultiWaitType* p) NN_NOEXCEPT
    {
        os::LinkMultiWaitHolder(p, &m_MultiWaitHolder);
    }

    void UnlinkMultiWaitHolders(::nn::os::MultiWaitType* p) NN_NOEXCEPT
    {
        NN_UNUSED(p);
        os::UnlinkMultiWaitHolder(&m_MultiWaitHolder);
    }

    bool HandleEventIfHolderOwner(::nn::os::MultiWaitHolderType* holder) NN_NOEXCEPT;

private:
    ::nn::spsm::server::PowerStateMessageQueue* m_pPowerStateMessageQueue;

    ::nn::os::SystemEventType     m_SleepRequired;
    ::nn::os::MultiWaitHolderType m_MultiWaitHolder;
};

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

