﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>
#include <nn/tcap/tcap.h>

#include "spsm_ThermalCoordinatorAdvancedPolicy.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void ThermalCoordinatorAdvancedPolicy::Initialize(::nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;

    ::nn::tcap::Initialize();
    ::nn::tcap::GetContinuousHighSkinTemperatureEvent(&m_SleepRequired, ::nn::os::EventClearMode_AutoClear);
    ::nn::os::InitializeMultiWaitHolder(&m_MultiWaitHolder, &m_SleepRequired);

    m_MultiWaitHolder.userData = reinterpret_cast<uintptr_t>(this);
}


//-----------------------------------------------------------------------------
//  デストラクタ
//
void ThermalCoordinatorAdvancedPolicy::Finalize() NN_NOEXCEPT
{
    ::nn::os::FinalizeMultiWaitHolder(&m_MultiWaitHolder);
    ::nn::os::DestroySystemEvent(&m_SleepRequired);
    ::nn::tcap::Finalize();
}

//-----------------------------------------------------------------------------
//  ThermalCoordinatorAdvancedPolicy のハンドラ関数（多重待ち解除時に呼ばれる）
//
bool ThermalCoordinatorAdvancedPolicy::HandleEventIfHolderOwner(::nn::os::MultiWaitHolderType* holder) NN_NOEXCEPT
{
    bool isHolderOwner = (holder == &m_MultiWaitHolder);

    if ( isHolderOwner )
    {
        if ( ::nn::os::TryWaitSystemEvent(&m_SleepRequired) )
        {
            m_pPowerStateMessageQueue->Enqueue(AddTimeStamp(::nn::spsm::server::PowerStateMessage_EventSleepRequiredByHighTemperature));
        }
    }

    return isHolderOwner;
}

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

