﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/tc/tc.h>
#include <nn/tc/tc_PowerState.h>

#include "spsm_ThermalCoordinator.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void ThermalCoordinator::Initialize(nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;

    nn::tc::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::tc::GetThermalEvent(&m_SleepRequired, nn::tc::EventTarget_AbnormalTemperature, os::EventClearMode_AutoClear));
    os::InitializeMultiWaitHolder(&m_ThermalCoordinatorHolder, &m_SleepRequired);

    m_ThermalCoordinatorHolder.userData = reinterpret_cast<uintptr_t>(this);
}


//-----------------------------------------------------------------------------
//  デストラクタ
//
void ThermalCoordinator::Finalize() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_ThermalCoordinatorHolder);
    nn::os::DestroySystemEvent(&m_SleepRequired);
    nn::tc::Finalize();
}


//-----------------------------------------------------------------------------
//  ThermalCoordinator のハンドラ関数（多重待ち解除時に呼ばれる）
//
void ThermalCoordinator::ProcessThermalCoordinator() NN_NOEXCEPT
{
    if ( !nn::os::TryWaitSystemEvent(&m_SleepRequired) )
    {
        return;
    }

    NotifyThermalCoordinator();
}

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

