﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/spsm/spsm_PowerStateTypes.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>

namespace nn { namespace spsm { namespace observer {

class IEventHandler
{
    NN_DISALLOW_COPY(IEventHandler);
    NN_DISALLOW_MOVE(IEventHandler);

public:
    IEventHandler() NN_NOEXCEPT {}
    virtual ~IEventHandler() NN_NOEXCEPT {}

    virtual void Initialize(nn::spsm::server::PowerStateMessageQueue*) NN_NOEXCEPT = 0;
    virtual void Finalize() NN_NOEXCEPT = 0;
    virtual void LinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT = 0;
    virtual void UnlinkMultiWaitHolders(::nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT = 0;
    virtual bool HandleEventIfHolderOwner(::nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT = 0;

    // 以下の二つは EventHandlerManager のループとは別スレッドから呼ばれるため、排他に注意すること
    virtual void OnPowerStateEntry(::nn::spsm::PowerState enteredState) NN_NOEXCEPT
    {
        NN_UNUSED(enteredState);
    }
    virtual void OnPowerStateExit(::nn::spsm::PowerState exitedState) NN_NOEXCEPT
    {
        NN_UNUSED(exitedState);
    }
};

}}} // namespace nn::spsm::observer
