﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/settings/factory/settings_Result.h>
#include <nn/settings/factory/settings_Usb.h>
#include <nn/settings/system/settings_Usb.h>

#include "detail/settings_UsbImpl.h"

namespace nn { namespace settings { namespace factory {

::nn::Result GetUsbTypeCPowerSourceCircuitVersion(
    ::nn::Bit8* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetUsbTypeCPowerSourceCircuitVersion(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::settings::factory

namespace nn { namespace settings { namespace system {

bool IsUsb30Enabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetUsb30EnableFlag(&value));
    return value;
}

void SetUsb30Enabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetUsb30EnableFlag(enable));
}

}}} // namespace nn::settings::system
