﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>

#include "detail/settings_SettingsSetterApiImpl.h"

namespace nn { namespace settings { namespace fwdbg {

void SetSettingsItemValue(const char* name,
                          const char* key,
                          const void* pValue,
                          size_t valueSize) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetSettingsItemValue(
            name, key, pValue, valueSize));
}

void ResetSettingsItemValue(const char* name, const char* key) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::ResetSettingsItemValue(name, key));
}

}}} // namespace nn::settings::hwdbg
