﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/fwdbg/settings_SettingsManagement.h>

#include "detail/settings_SettingsManagementImpl.h"

namespace nn { namespace settings { namespace fwdbg {

size_t ReadSettings(
    ::nn::Bit8 outBuffer[], size_t count, SettingsTarget target) NN_NOEXCEPT
{
    auto outCount = uint64_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::ReadSettings(
            &outCount, outBuffer, count, static_cast<int32_t>(target)));
    return static_cast<size_t>(outCount);
}

void ResetSettings(SettingsTarget target) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::ResetSettings(static_cast<int32_t>(target)));
}

}}} // namespace nn::settings::fwdbg
