﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Hid.h>

#include "detail/settings_HidImpl.h"

namespace nn { namespace settings { namespace system {

bool IsUsbFullKeyEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetUsbFullKeyEnableFlag(&value));
    return value;
}

void SetUsbFullKeyEnabled(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetUsbFullKeyEnableFlag(value));
}

float GetVibrationMasterVolume() NN_NOEXCEPT
{
    auto value = float();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetVibrationMasterVolume(&value));
    return value;
}

void SetVibrationMasterVolume(float value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetVibrationMasterVolume(value));
}

int GetNxControllerSettings(
    NxControllerSettings outValues[], int count) NN_NOEXCEPT
{
    int32_t gotCount = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetNxControllerSettings(
            &gotCount, outValues, count));
    return gotCount;
}

void SetNxControllerSettings(
    const NxControllerSettings values[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetNxControllerSettings(values, count));
}

}}} // namespace nn::settings::system
