﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/settings/system/settings_BluetoothDevices.h>

#include "detail/settings_BluetoothDevicesImpl.h"

namespace nn { namespace settings { namespace system {

int GetBluetoothDevicesSettings(
    BluetoothDevicesSettings outValues[], int count) NN_NOEXCEPT
{
    auto value = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetBluetoothDevicesSettings(
            &value, outValues, count));
    return value;
}

void SetBluetoothDevicesSettings(
    const BluetoothDevicesSettings values[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetBluetoothDevicesSettings(values, count));
}

bool IsBluetoothEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetBluetoothEnableFlag(&value));
    return value;
}

void SetBluetoothEnabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetBluetoothEnableFlag(enable));
}

bool IsBluetoothAfhEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetBluetoothAfhEnableFlag(&value));
    return value;
}

void SetBluetoothAfhEnabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetBluetoothAfhEnableFlag(enable));
}

bool IsBluetoothBoostEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetBluetoothBoostEnableFlag(&value));
    return value;
}

void SetBluetoothBoostEnabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetBluetoothBoostEnableFlag(enable));
}

int GetBlePairingSettings(
    BlePairingSettings outValues[], int count) NN_NOEXCEPT
{
    auto value = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetBlePairingSettings(
            &value, outValues, count));
    return value;
}

void SetBlePairingSettings(
    const BlePairingSettings values[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetBlePairingSettings(values, count));
}

}}} // namespace nn::settings::system
