﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Audio.h>

#include "detail/settings_AudioImpl.h"

namespace nn { namespace settings { namespace system {

void GetAudioVolume(
    AudioVolume* pOutAudioVolume, AudioVolumeTarget target) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAudioVolume(
            pOutAudioVolume, static_cast<int32_t>(target)));
}

void SetAudioVolume(
    const AudioVolume& audioVolume, AudioVolumeTarget target) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAudioVolume(
            audioVolume, static_cast<int32_t>(target)));
}

AudioOutputMode GetAudioOutputMode(AudioOutputModeTarget target) NN_NOEXCEPT
{
    auto value = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAudioOutputMode(
            &value, static_cast<int32_t>(target)));
    return static_cast<AudioOutputMode>(value);
}

void SetAudioOutputMode(
    AudioOutputMode audioOutputMode, AudioOutputModeTarget target) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAudioOutputMode(
            static_cast<int32_t>(audioOutputMode),
            static_cast<int32_t>(target)));
}

bool IsForceMuteOnHeadphoneRemoved() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::IsForceMuteOnHeadphoneRemoved(&value));
    return value;
}

void SetForceMuteOnHeadphoneRemoved(bool forceMute) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetForceMuteOnHeadphoneRemoved(forceMute));
}

int GetHeadphoneVolumeWarningDisplayedEventCount() NN_NOEXCEPT
{
    auto value = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetHeadphoneVolumeWarningCount(&value));
    return static_cast<int>(value);
}

void SetHeadphoneVolumeWarningDisplayedEventCount(int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetHeadphoneVolumeWarningCount(
            static_cast<int32_t>(count)));
}

bool GetHeadphoneVolumeUpdateFlag() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetHeadphoneVolumeUpdateFlag(&value));
    return value;
}

void SetHeadphoneVolumeUpdateFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetHeadphoneVolumeUpdateFlag(value));
}

bool NeedsToUpdateHeadphoneVolume(
    bool* pOutIsHighPowerAvailable, int8_t* pOutVolume, bool isRestricted
    ) NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::NeedsToUpdateHeadphoneVolume(
            &value, pOutIsHighPowerAvailable, pOutVolume, isRestricted));
    return value;
}

}}} // namespace nn::settings::system
