﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISettingsServer.sfdl.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_SettingsServer.h"
#include "settings_SystemApplicationImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetLockScreenFlag(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetLockScreenFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetLockScreenFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetLockScreenFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetColorSetId(int32_t* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetColorSetId(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetColorSetId(int32_t value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetColorSetId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetBatteryPercentageFlag(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetBatteryPercentageFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetBatteryPercentageFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetBatteryPercentageFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetInitialLaunchSettings(
    ::nn::settings::system::InitialLaunchSettings* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetInitialLaunchSettings(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetInitialLaunchSettings(
    const ::nn::settings::system::InitialLaunchSettings& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetInitialLaunchSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetDeviceNickName(
    ::nn::settings::system::DeviceNickName* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetDeviceNickName(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetDeviceNickName(
    const ::nn::settings::system::DeviceNickName& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetDeviceNickName(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetQuestFlagForApplication(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISettingsServer> pProxy;
    NN_RESULT_DO(CreateSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetQuestFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetQuestFlagForSystemApplication(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetQuestFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetQuestFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetQuestFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAppletLaunchFlags(
    ::nn::settings::system::AppletLaunchFlagSet* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAppletLaunchFlags(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetAppletLaunchFlags(
    const ::nn::settings::system::AppletLaunchFlagSet& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetAppletLaunchFlags(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetWirelessCertificationFileSize(uint64_t* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetWirelessCertificationFileSize(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result GetWirelessCertificationFile(
    uint64_t* pOutValue, void* outBuffer, size_t size) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(
        pProxy->GetWirelessCertificationFile(
            pOutValue,
            ::nn::sf::OutBuffer(reinterpret_cast<char*>(outBuffer), size)));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
