﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace settings { namespace detail {

//!< 設定の名前をコピーします。
void CopySettingsName(SettingsName* pOutValue, const char* name) NN_NOEXCEPT;

//!< 設定項目のキー名をコピーします。
void CopySettingsItemKey(
    SettingsItemKey* pOutValue, const char* key) NN_NOEXCEPT;

::nn::Result GetDebugModeFlag(bool* pOutValue) NN_NOEXCEPT;

::nn::Result GetSettingsItemValueSize(
    size_t* outValue, const char* name, const char* key) NN_NOEXCEPT;

::nn::Result GetSettingsItemValue(
    size_t* outValue, void* buffer, size_t bufferSize,
    const char* name, const char* key) NN_NOEXCEPT;

::nn::Result CreateSettingsItemKeyIterator(
    ::nn::settings::fwdbg::SettingsItemKeyIterator* outValue,
    const char* name) NN_NOEXCEPT;

::nn::Result DestroySettingsItemKeyIterator(
    ::nn::settings::fwdbg::SettingsItemKeyIterator* pIterator) NN_NOEXCEPT;

::nn::Result AdvanceSettingsItemKeyIterator(
    ::nn::settings::fwdbg::SettingsItemKeyIterator* pIterator) NN_NOEXCEPT;

::nn::Result GetSettingsItemKeySize(
    size_t* outValue,
    const ::nn::settings::fwdbg::SettingsItemKeyIterator& iterator) NN_NOEXCEPT;

::nn::Result GetSettingsItemKey(
    size_t* outValue, void* buffer, size_t bufferSize,
    const ::nn::settings::fwdbg::SettingsItemKeyIterator& iterator) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
