﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_News.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_NewsImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetAutomaticApplicationDownloadFlag(bool* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetAutomaticApplicationDownloadFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetAutomaticApplicationDownloadFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetAutomaticApplicationDownloadFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetNotificationSettings(
    ::nn::settings::system::NotificationSettings* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetNotificationSettings(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetNotificationSettings(
    const ::nn::settings::system::NotificationSettings& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetNotificationSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetAccountNotificationSettings(
    int32_t* pOutCount,
    ::nn::settings::system::AccountNotificationSettings outValues[],
    size_t count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::OutArray<::nn::settings::system::AccountNotificationSettings>
        outArray(outValues, count);
    NN_RESULT_DO(pProxy->GetAccountNotificationSettings(pOutCount, outArray));
    NN_RESULT_SUCCESS;
}

::nn::Result SetAccountNotificationSettings(
    const ::nn::settings::system::AccountNotificationSettings* values,
    size_t count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    ::nn::sf::InArray<::nn::settings::system::AccountNotificationSettings>
        inArray(values, count);
    NN_RESULT_DO(pProxy->SetAccountNotificationSettings(inArray));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
