﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_Keyboard.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetKeyboardLayout(KeyboardLayout* pOutValue) NN_NOEXCEPT;

::nn::Result SetKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT;

::nn::Result GetApplicationOwnKeyboardLayout(
    bool* pOutFlag, KeyboardLayout* pOutLayout) NN_NOEXCEPT;

::nn::Result SetApplicationOwnKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
