﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/factory/settings_BatteryLot.h>
#include <nn/settings/factory/settings_Bluetooth.h>
#include <nn/settings/factory/settings_ConfigurationId.h>
#include <nn/settings/factory/settings_DeviceCertificate.h>
#include <nn/settings/factory/settings_GameCard.h>
#include <nn/settings/factory/settings_MotionSensor.h>
#include <nn/settings/factory/settings_SerialNumber.h>
#include <nn/settings/factory/settings_Speaker.h>
#include <nn/settings/factory/settings_WirelessLan.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_Out.h>

#include "settings_CalibrationBinaryDatabase.h"
#include "settings_FactorySettingsServer.h"
#include "settings_StaticObject.h"
#include "settings_SystemSettingsDatabase.h"

namespace nn { namespace settings { namespace detail {


FactorySettingsServer::FactorySettingsServer() NN_NOEXCEPT
{
    // 何もしない
}

::nn::Result FactorySettingsServer::GetBluetoothBdAddress(
    ::nn::sf::Out<::nn::settings::factory::BdAddress> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinBluetoothBdAddress(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetConfigurationId1(
    ::nn::sf::Out<::nn::settings::factory::ConfigurationId1> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinConfigurationId1(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAccelerometerOffset(
    ::nn::sf::Out<::nn::settings::factory::AccelerometerOffset> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAccelerometerOffset(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAccelerometerScale(
    ::nn::sf::Out<::nn::settings::factory::AccelerometerScale> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAccelerometerScale(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetGyroscopeOffset(
    ::nn::sf::Out<::nn::settings::factory::GyroscopeOffset> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinGyroscopeOffset(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetGyroscopeScale(
    ::nn::sf::Out<::nn::settings::factory::GyroscopeScale> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinGyroscopeScale(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetSerialNumber(
    ::nn::sf::Out<::nn::settings::factory::SerialNumber> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinSerialNumber(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetWirelessLanMacAddress(
    ::nn::sf::Out<::nn::settings::factory::MacAddress> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinWirelessLanMacAddress(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetWirelessLanCountryCodeCount(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinWirelessLanCountryCodeCount(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetWirelessLanCountryCodes(
    ::nn::sf::Out<int32_t> outValue,
    const ::nn::sf::OutArray<::nn::settings::factory::CountryCode>& outCodes
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinWirelessLanCountryCodes(outValue.GetPointer(),
                                                    outCodes.GetData(),
                                                    outCodes.GetLength()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::SetInitialSystemAppletProgramId(
    ::nn::ncm::ProgramId value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsInitialSystemAppletProgramId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::SetOverlayDispProgramId(
    ::nn::ncm::ProgramId value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsOverlayDispProgramId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetBatteryLot(
    ::nn::sf::Out<::nn::settings::factory::BatteryLot> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinBatteryLot(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEciDeviceCertificate(
    ::nn::sf::Out<
        ::nn::settings::factory::EccB233DeviceCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinEccB233DeviceCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEticketDeviceCertificate(
    ::nn::sf::Out<
        ::nn::settings::factory::Rsa2048DeviceCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinRsa2048ETicketCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetSslKey(
    ::nn::sf::Out<::nn::settings::factory::SslKey> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinSslKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetSslCertificate(
    ::nn::sf::Out<
        ::nn::settings::factory::SslCertificate> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinSslCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetGameCardKey(
    ::nn::sf::Out<::nn::settings::factory::GameCardKey> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinGameCardKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetGameCardCertificate(
    ::nn::sf::Out<
        ::nn::settings::factory::GameCardCertificate> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinGameCardCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEciDeviceKey(
    ::nn::sf::Out<
        ::nn::settings::factory::EccB233DeviceKey> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinEccB233DeviceKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEticketDeviceKey(
    ::nn::sf::Out<
        ::nn::settings::factory::Rsa2048DeviceKey> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinRsa2048ETicketKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetSpeakerParameter(
    ::nn::sf::Out<
        ::nn::settings::factory::SpeakerParameter> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinSpeakerParameter(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetLcdVendorId(
    ::nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinLcdVendorId(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEciDeviceCertificate2(
    ::nn::sf::Out<
        ::nn::settings::factory::Rsa2048DeviceCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinRsa2048DeviceCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetEciDeviceKey2(
    ::nn::sf::Out<nn::settings::factory::Rsa2048DeviceKey> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinRsa2048DeviceKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboKey(
    ::nn::sf::Out<::nn::settings::factory::AmiiboKey> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAmiiboKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboEcqvCertificate(
    ::nn::sf::Out<::nn::settings::factory::AmiiboEcqvCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAmiiboEcqvCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboEcdsaCertificate(
    ::nn::sf::Out<::nn::settings::factory::AmiiboEcdsaCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAmiiboEcdsaCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboEcqvBlsKey(
    ::nn::sf::Out<::nn::settings::factory::AmiiboEcqvBlsKey> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAmiiboEcqvBlsKey(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboEcqvBlsCertificate(
    ::nn::sf::Out<::nn::settings::factory::AmiiboEcqvBlsCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinAmiiboEcqvBlsCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetAmiiboEcqvBlsRootCertificate(
    ::nn::sf::Out<
        ::nn::settings::factory::AmiiboEcqvBlsRootCertificate> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibBinAmiiboEcqvBlsRootCertificate(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result FactorySettingsServer::GetUsbTypeCPowerSourceCircuitVersion(
    ::nn::sf::Out<::nn::Bit8> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibBinUsbTypeCPowerSourceCircuitVersion(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result CreateFactorySettingsServerProxy(
    ::nn::sf::SharedPointer<IFactorySettingsServer>* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    *pOutValue = StaticObject<
        ::nn::sf::UnmanagedServiceObject<
            IFactorySettingsServer, FactorySettingsServer>>::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // nn::settings::detail
