﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_DebugPadMap.h>
#include <nn/settings/settings_DebugPad.h>

#include "settings_DebugPadImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetDebugPadGenericPadMap(DebugPadGenericPadMap* outValue
                                      ) NN_NOEXCEPT
{
    return ::nn::hid::GetDebugPadGenericPadMap(outValue);
}

::nn::Result SetDebugPadGenericPadMap(const DebugPadGenericPadMap& value
                                      ) NN_NOEXCEPT
{
    return ::nn::hid::SetDebugPadGenericPadMap(value);
}

::nn::Result ResetDebugPadGenericPadMap() NN_NOEXCEPT
{
    return ::nn::hid::ResetDebugPadGenericPadMap();
}

::nn::Result GetDebugPadKeyboardMap(DebugPadKeyboardMap* outValue) NN_NOEXCEPT
{
    return ::nn::hid::GetDebugPadKeyboardMap(outValue);
}

::nn::Result SetDebugPadKeyboardMap(const DebugPadKeyboardMap& value
                                    ) NN_NOEXCEPT
{
    return ::nn::hid::SetDebugPadKeyboardMap(value);
}

::nn::Result ResetDebugPadKeyboardMap() NN_NOEXCEPT
{
    return ::nn::hid::ResetDebugPadKeyboardMap();
}

}}} // namespace nn::settings::detail
