﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/factory/settings_ConfigurationId.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_ConfigurationIdImpl.h"
#include "settings_FactorySettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetConfigurationId1(
    ::nn::settings::factory::ConfigurationId1* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IFactorySettingsServer>();
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConfigurationId1(pOutValue));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
