﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;


namespace nn.sasbus
{
    // 実操作を担当する SASBUS のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/sasbus/sasbus_ISession.sfdl.h>")]
    interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result Send([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer inData, char_t reg );

        [MethodId(1)]
        Result Receive([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer outData, char_t reg );

        [MethodId(2)]
        Result StartPeriodicReceiveMode(NativeHandle receiveBufferHandle, uint64_t receiveBufferSize, char_t reg, int size, int64_t interval);

        [MethodId(3)]
        Result StopPeriodicReceiveMode();
    }

    // Sasbus セッションを返すマネージャークラス
    [CppRefPath("<nn/sasbus/sasbus_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenSession(Out<ISession> outSession, int32_t device);
    }
}
