﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_TimeSpan.h>

#include <nne/spi/spi_api.h>
#include <nn/sasbus/sasbus_DeviceName.h>

namespace nn {
namespace sasbus {
namespace driver {
namespace detail {

struct DeviceSetting
{
    nn::sasbus::SasbusDevice  device;            // デバイス識別子
    const int                 BusIndex;          // バス番号
    const char*               Name;              // nne 向け識別子
    const nne::spi::SpiMode   Mode;              // SPI のモード
    const nne::spi::SpiBits   Bits;              // Bit 設定
    const nne::spi::CLOCK     Clock;             // クロック
};

} // detail
} // driver
} // sasbus
} // nn

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    #include "sasbus_TargetSpec-hardware.nx.h"
#else
    #include "sasbus_TargetSpec-stub.h"
#endif
