﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_Mutex.h>

#include <nn/sasbus/driver/sasbus_Bus.h>
#include <nne/spi/spi_api.h>

namespace nn {
namespace sasbus {
namespace driver {
namespace detail {

struct StaticMutex
{
    nn::os::MutexType mutex;
    void lock() NN_NOEXCEPT
    {
        nn::os::LockMutex(&mutex);
    }
    void unlock() NN_NOEXCEPT
    {
        nn::os::UnlockMutex(&mutex);
    }
};

/**
 * @brief   チャンネルセッションの実データ構造体
 */
struct SessionImpl
{
    nn::sasbus::SasbusDevice      device;
    nne::spi::SpiSession          session;
    // TORIAEZU : PeriodicReceiveMode 用パラメタ
    char              reg;
    nn::TimeSpan      interval;
    int               dataSize;
    StaticMutex       transactionMutex;
    int64_t           sampleNumber;
    void*             pRingLifo;
};

struct SessionImplPadded
{
    SessionImpl  impl;

    // Session 型の TypedStorage とサイズを合わせるための微調整部分
    char                _padding[SessionSize - sizeof(SessionImpl)];
};

NN_FORCEINLINE
SessionImpl& ToSessionImpl(Session& session)
{
    return nn::util::Get<SessionImplPadded>(session._impl).impl;
}

NN_FORCEINLINE
const SessionImpl& ToSessionImpl(const Session& session)
{
    return nn::util::Get<SessionImplPadded>(session._impl).impl;
}

} // detail
} // driver
} // sasbus
} // nn
