﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Spec により ChannelName の列挙子定義が異なる
#include <nn/pwm/pwm_ChannelName.h>
#include <nn/spl/spl_Api.h>

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

// 各チャンネルに対応するデバイス名
// ChannelName_Invalid はデバイス名ではアクセスできず、ForDev API でのみアクセス可
const ChannelName ChannelNameMap[] =
{
    // PWM0
    // note: 使うには、LCD_BL_PWM の pinmux を PM3_PWM0 に切り替えておく必要がある
    ChannelName::ChannelName_LcdBacklight,

    // PWM1
    ChannelName::ChannelName_CpuFan,

    // PWM2
    ChannelName::ChannelName_Invalid,

    // PWM3
    ChannelName::ChannelName_Invalid,
};

// 各チャンネルがどのボードに対応しているかの情報
struct ChannelSupportInfo
{
    ChannelName name;
    nn::Bit16   supportBoardFlag;
};

const ChannelSupportInfo ChannelSupportInfoMap[] =
{
    { ChannelName_Invalid , 0},
    { ChannelName_CpuFan,        1 << nn::spl::HardwareType_Hoag | 1 << nn::spl::HardwareType_Copper | 1 << nn::spl::HardwareType_Icosa | 1 << nn::spl::HardwareType_Iowa},
    // TORIAEZU : Lcd BackLight は Copper 向けにはいらないはずだが、 lbl の整理が必要なため、一旦 support 対象に入れる
    { ChannelName_LcdBacklight,  1 << nn::spl::HardwareType_Hoag | 1 << nn::spl::HardwareType_Copper | 1 << nn::spl::HardwareType_Icosa | 1 << nn::spl::HardwareType_Iowa},
    { ChannelName_BlinkLed,      1 << nn::spl::HardwareType_Copper },
};

} // detail
} // driver
} // channel
} // nn
