﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/psm/psm_IPsmServer.sfdl.h>
#include <nn/psm/psm_PsmServer.h>
#include <nn/psm/psm_ServiceName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ISharedObject.h>

#include "psm_PsmServerByHipc.h"

namespace nn { namespace psm {

namespace {

//!< IPC 用ヒープメモリを扱うクラスです。
typedef ::nn::sf::ExpHeapStaticAllocator<16 * 1024, PsmServer> Allocator;

class AllocatorInitializer
{
public:
    AllocatorInitializer() NN_NOEXCEPT
    {
        Allocator::Initialize(::nn::lmem::CreationOption_NoOption);
    }
};

} // namespace

::nn::sf::SharedPointer<IPsmServer> GetPsmServerByHipc() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(AllocatorInitializer, s_AllocatorInitializer);
    NN_UNUSED(s_AllocatorInitializer);

    ::nn::sf::SharedPointer<IPsmServer> server;

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        (::nn::sf::CreateHipcProxyByName<IPsmServer, Allocator::Policy>)
        (&server, ::nn::psm::ServiceName));

    return server;
}

}} // namespace nn::psm
