﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/fan/fan.h>
#include <nn/gpio/gpio_PadAccessor.h>
#include <nn/os/os_Mutex.h>

#include "psm_ISupplyRouteDriver.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class SupplyRouteDriver final : public ISupplyRouteDriver
{
    NN_DISALLOW_COPY(SupplyRouteDriver);
    NN_DISALLOW_MOVE(SupplyRouteDriver);

private:
    enum class Vdd50State
    {
        Unknown, //! 初期状態のため不明
        None,    //! VDD50A, B ともに無効
        Vdd50A,  //! VDD50A のみ有効
        Vdd50B,  //! VDD50B のみ有効
    };

public:
    SupplyRouteDriver() NN_NOEXCEPT;

    virtual ~SupplyRouteDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result SetSupplyRoute(SupplyRoute supplyRoute) NN_NOEXCEPT NN_OVERRIDE;

private:
    //! 給電経路の変更の有無
    bool IsSupplyRouteUpdated(Vdd50State newState) NN_NOEXCEPT;

    //! 給電経路の切断
    void Disconnect() NN_NOEXCEPT;

    //! 給電経路の接続
    void Connect(Vdd50State newState) NN_NOEXCEPT;

private:
    //! VDD50A, B の状態
    Vdd50State m_Vdd50State;

    //! VDD50A を操作するためのセッション
    ::nn::gpio::GpioPadSession m_Vdd50ASession;

    //! VDD50B を操作するためのセッション
    ::nn::gpio::GpioPadSession m_Vdd50BSession;

    //! ファン制御
    ::nn::fan::Controller m_FanController;

    //! VDD50 切り替え処理の排他
    ::nn::os::Mutex m_UpdateMutex;

    //! 前回 VDD50A, VDD50B ともに無効に設定した時間
    ::nn::TimeSpan m_LastVdd50OffTime;
};

}}}} // namespace nn::psm::driver::detail
