﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "psm_FirmwareDebugSettingsAccessor.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class SettingsHolder
{
    NN_DISALLOW_COPY(SettingsHolder);
    NN_DISALLOW_MOVE(SettingsHolder);

public:
    SettingsHolder() NN_NOEXCEPT;

    //! settings からの設定の取得。
    void LoadSettings() NN_NOEXCEPT;

    //! 評価用のログが有効かの取得。
    bool IsEvaluationLogEnabled() const NN_NOEXCEPT;

    //! 充電電流上限の上限を取得します。
    int GetChargeCurrentLimitMilliAmpere() const NN_NOEXCEPT;

    //! USB を使用した給電・放電に関する処理の有効・無効を取得します。
    bool IsUsbPowerManagementSupported() const NN_NOEXCEPT;

    //! 電池の有無を取得します。
    bool HasBattery() const NN_NOEXCEPT;

    //! チャージャードライバの有効・無効を取得します。
    bool IsChargerDriverEnabled() const NN_NOEXCEPT;

    //! 電池残量計ドライバの有効・無効を取得します。
    bool IsFuelGaugeDriverEnabled() const NN_NOEXCEPT;

    //! 給電経路ドライバの有効・無効を取得します。
    bool IsSupplyRouteDriverEnabled() const NN_NOEXCEPT;

    //! VDD50B の有効・無効を取得します。
    bool IsVdd50BEnabled() const NN_NOEXCEPT;

    //! USB Type-C Power Source 回路バージョンを取得します。
    int GetUsbTypeCPowerSourceCircuitVersion() const NN_NOEXCEPT;

private:
    //! 評価用のログが有効か。
    bool m_EvaluationLogEnabled;

    //! 充電電流上限の上限
    int m_ChargeCurrentLimitMilliAmpere;

    //! USB を使用した給電・放電に関する処理の有効・無効
    bool m_UsbPowerManagementSupport;

    //! 電池の有無
    bool m_HasBattery;

    //! チャージャードライバの有効・無効
    bool m_EnableChargerDriver;

    //! 電池残量計ドライバの有効・無効
    bool m_EnableFuelGaugeDriver;

    //! 給電経路ドライバの有効・無効
    bool m_EnableSupplyRouteDriver;

    //! VDD50B の有効・無効
    bool m_EnableVdd50B;

    //! Firmware Debug Settings にアクセスするためのオブジェクト。
    FirmwareDebugSettingsAccessor m_FirmwareDebugSettingsAccessor;

    //! USB Type-C Power Source 回路バージョン
    int m_UsbTypeCPowerSourceCircuitVersion;
};

}}}} // namespace nn::psm::driver::detail
