﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace psm { namespace driver { namespace detail {

// TODO: spec NX 依存の定義なので -spec.nx.h に移動させます。
enum SupplyRoute
{
    SupplyRoute_Invalid,
    SupplyRoute_None,
    SupplyRoute_Vdd50A,
    SupplyRoute_Vdd50B,
};

class ISupplyRouteDriver
{
    NN_DISALLOW_COPY(ISupplyRouteDriver);
    NN_DISALLOW_MOVE(ISupplyRouteDriver);

public:
    ISupplyRouteDriver() NN_NOEXCEPT
    {
        // 何もしません。
    }

    virtual ~ISupplyRouteDriver() NN_NOEXCEPT
    {
        // 何もしません。
    }

    virtual ::nn::Result SetSupplyRoute(SupplyRoute supplyRoute) NN_NOEXCEPT = 0;
};

}}}} // namespace nn::psm::driver::detail
