﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "psm_IFuelGaugeDriver.h"
#include "psm_IFuelGaugeParameterManager.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class FuelGaugeParameterManager final : public IFuelGaugeParameterManager
{
    NN_DISALLOW_COPY(FuelGaugeParameterManager);
    NN_DISALLOW_MOVE(FuelGaugeParameterManager);

public:
    FuelGaugeParameterManager() NN_NOEXCEPT
        : m_pFuelGaugeDriver(nullptr)
        , m_IsUpdateEnabled(false)
    {
        // 何もしません。
    }

    ~FuelGaugeParameterManager() NN_NOEXCEPT
    {
        // 何もしません。
    }

    ::nn::Result Initialize(IFuelGaugeDriver* pFuelGaugeDriver) NN_NOEXCEPT;

    ::nn::Result SaveParameter() NN_NOEXCEPT;

    ::nn::Result RestoreParameter() NN_NOEXCEPT;

    ::nn::Result FlushParameter() NN_NOEXCEPT;

private:
    ::nn::Result InitializeParameter() NN_NOEXCEPT;

private:
    IFuelGaugeDriver* m_pFuelGaugeDriver;

    bool m_IsUpdateEnabled;
};

}}}} // namespace nn::psm::driver::detail
