﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "psm_BatteryTemperatureLevel.h"
#include "psm_BatteryVoltageLevelForCharge.h"
#include "psm_ChargeParameterRule.h"
#include "psm_PowerState.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! NX 向け充電パラメータの導出ルール
class ChargeParameterRule
{
    NN_DISALLOW_COPY(ChargeParameterRule);
    NN_DISALLOW_MOVE(ChargeParameterRule);

public:
    ChargeParameterRule() NN_NOEXCEPT;

    ~ChargeParameterRule() NN_NOEXCEPT;

    //! 電池温度レベルを設定します。
    void SetBatteryTemperatureLevel(BatteryTemperatureLevel batteryTemperatureLevel) NN_NOEXCEPT;

    //! 電池電圧レベルを設定します。
    void SetBatteryVoltageLevel(BatteryVoltageLevelForCharge batteryVoltageLevel) NN_NOEXCEPT;

    //! 電源状態を設定します。
    void SetPowerState(PowerState powerState) NN_NOEXCEPT;

    //! 充電電流上限を取得します。
    int GetChargeCurrentLimitMilliAmpere() NN_NOEXCEPT;

    //! 充電電圧上限を取得します。
    int GetChargeVoltageLimitMilliVolt() NN_NOEXCEPT;

    //! 充電可否を取得します。
    bool GetChargeAllowed() NN_NOEXCEPT;

private:
    //! 充電電流上限、充電電圧上限、充電可否を更新します。
    void Update() NN_NOEXCEPT;

private:
    //! 電池温度レベル
    BatteryTemperatureLevel m_BatteryTemperatureLevel;

    //! 電池電圧レベル
    BatteryVoltageLevelForCharge m_BatteryVoltageLevel;

    //! 電源状態
    PowerState m_PowerState;

    //! 充電電流上限
    int m_ChargeCurrentLimitMilliAmpere;

    //! 充電電圧上限
    int m_ChargeVoltageLimitMilliVolt;

    //! 充電可否
    bool m_ChargeAllowed;
};

}}}} // namespace nn::psm::driver::detail
