﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>

#include "psc_PmDependent.h"
#include "psc_PmModule.h"

namespace nn     {
namespace psc    {
namespace server {

PmDependent::PmDependent(PmModule* pModule)
NN_NOEXCEPT :
    m_pModule(pModule)
{
    NN_ABORT_UNLESS(pModule != nullptr);
    m_pModule->AddReference();
}

PmDependent::~PmDependent()
NN_NOEXCEPT
{
    if (m_pModule->RemoveReference())
    {
        delete m_pModule;
    }
}

PmModuleId PmDependent::Id()
NN_NOEXCEPT
{
    return m_pModule->Id();
}

nn::Result PmDependent::AddChild(PmModule* pChild)
NN_NOEXCEPT
{
    return m_pModule->AddChild(pChild);
}

nn::Result PmDependent::AddParent(PmModule* pParent)
NN_NOEXCEPT
{
    return m_pModule->AddParent(pParent);
}

void PmDependent::RemoveChild(PmModule* pChild)
NN_NOEXCEPT
{
    m_pModule->RemoveChild(pChild);
}

void PmDependent::RemoveParent(PmModule* pParent)
NN_NOEXCEPT
{
    m_pModule->RemoveParent(pParent);
}

PmModule* PmDependent::GetModulePointer()
NN_NOEXCEPT
{
    return m_pModule;
}

nn::Result PmDependent::ValidateDependency(PmModule* pParent, uint32_t iterationCounter)
NN_NOEXCEPT
{
    return m_pModule->ValidateDependency(pParent, iterationCounter);
}

nn::Result PmDependent::DispatchDescendingOrder(nn::os::SystemEvent** pEventOut, PmState state, PmFlagSet flags, uint32_t iterationCount)
NN_NOEXCEPT
{
    return m_pModule->DispatchDescendingOrder(pEventOut, state, flags, iterationCount);
}

nn::Result PmDependent::DispatchAscendingOrder(nn::os::SystemEvent** pEventOut, PmState state, PmFlagSet flags, uint32_t iterationCount)
NN_NOEXCEPT
{
    return m_pModule->DispatchAscendingOrder(pEventOut, state, flags, iterationCount);
}

uint32_t PmDependent::ChildDependencyLevels(uint32_t* pLevelsOut, uint32_t iterationCounter)
NN_NOEXCEPT
{
    return m_pModule->ChildDependencyLevels(pLevelsOut, iterationCounter);
}

uint32_t PmDependent::ParentDependencyLevels(uint32_t* pLevelsOut, uint32_t iterationCounter)
NN_NOEXCEPT
{
    return m_pModule->ParentDependencyLevels(pLevelsOut, iterationCounter);
}

}}}
