﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_HipcServer.h>
#include <nn/psc/psc_Types.h>
#include <nn/psc/sfdl/psc.sfdl.h>

namespace nn     {
namespace psc    {
namespace server {

class PmControlSfObject :
    public nn::sf::ISharedObject
{
private:
    nn::os::SystemEvent m_Event;
    bool m_Initialized;

public:
    nn::Result PrintModuleInformation()
    NN_NOEXCEPT;

    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut)
    NN_NOEXCEPT;

    nn::Result DispatchRequest(PmState state, PmFlagSet flags, PmTransitionOrder order)
    NN_NOEXCEPT;

    nn::Result GetState(nn::sf::Out<PmControlState> state)
    NN_NOEXCEPT;

    nn::Result GetResult()
    NN_NOEXCEPT;

    nn::Result Cancel()
    NN_NOEXCEPT;

    nn::Result GetModuleInformation(
        nn::sf::Out<nn::psc::util::TransitionInformation> transitionInfo,
        nn::sf::Out<std::int32_t> moduleCount,
        const nn::sf::OutBuffer& moduleInfo,
        nn::sf::Out<std::int32_t> dependencyCount,
        const nn::sf::OutBuffer& dependencyInfo
    )
    NN_NOEXCEPT;

    PmControlSfObject()
    NN_NOEXCEPT;

    ~PmControlSfObject()
    NN_NOEXCEPT;
};

}}}
