﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_ThreadTypes.h>

namespace nn { namespace profiler {

struct ThreadListItem
{
    nn::os::ThreadType* threadType;
    uint64_t threadId;
    char threadName[nn::os::ThreadNameLengthMax];
    int priority;
    int coreMask;
    int idealCore;

    NN_IMPLICIT ThreadListItem(nn::os::ThreadId thread);
    ~ThreadListItem();

    // no default ctor, copy ctor, move ctor, or assignment
    ThreadListItem() = delete;
    ThreadListItem(const ThreadListItem&) = delete;
    ThreadListItem(ThreadListItem&&) = delete;
    ThreadListItem& operator=(const ThreadListItem&) = delete;
    ThreadListItem& operator=(ThreadListItem&&) = delete;

    void Fill(nn::os::ThreadType* thread);
    void SetThreadName(const char* name);
};


}} // nn::profiler
