#/*--------------------------------------------------------------------------------*
#  Copyright (C)Nintendo All rights reserved.
#
#  These coded instructions, statements, and computer programs contain proprietary
#  information of Nintendo and/or its licensed developers and are protected by
#  national and international copyright laws. They may not be disclosed to third
#  parties or copied or duplicated in any form, in whole or in part, without the
#  prior written consent of Nintendo.
#
#  The content herein is highly confidential and should be handled accordingly.
# *--------------------------------------------------------------------------------*/

param (
    [Parameter(Mandatory=$true)][string]$OutputPath,
    [string]$SdkRoot = $ENV:NINTENDO_SDK_ROOT
)

$nvnSrcFolder = "$SdkRoot/Externals/odin2/common-headers/nvn/nvn"
if ($false -eq (test-path $nvnSrcFolder))
{
    write-error "Could not find NVN Src Folder: $nvnSrcFolder"
}

$outputLocation = $OutputPath | resolve-path


function Append-File
{
    param(
        [string]$Path,
        $InputObject
    )
    $InputObject | out-file $Path -Append -Encoding "UTF8"
}


if ($false -eq (test-path $outputLocation))
{
    mkdir $outputLocation
}

$nvnCsrc = "$nvnSrcFolder/nvn_FuncPtrImpl.h"
$nvnNameTable = "$outputLocation/profiler_NvnNameTable.autogen.h"

[regex]$searchFuncNames = [regex]'.*=.*\"(.*)\"'
[string[]]$funcNames = @()
$fileContents = [string[]](get-content $nvnCsrc)
foreach ($line in $fileContents)
{
    $match = $searchFuncNames.Match($line)
    if ($match.Success)
    {
        # Leading ',' enforces treating this as an array
        #   (not needed with initialization, but here to be safe)
        $funcNames += ,$match.Groups[1].Value
    }
}

[string]$copyrightNotice = 
"/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
// This file was automatically generated. Do not modify it directly."

$copyrightNotice | out-file $nvnNameTable -Encoding "UTF8"
append-file $nvnNameTable "#pragma once"
append-file $nvnNameTable "namespace nn { namespace profiler { namespace nvn {"
append-file $nvnNameTable "const char* gNvnFunctionNames[] = {"
foreach ($func in $funcNames)
{
    append-file $nvnNameTable "`"$func`","
}
append-file $nvnNameTable "};"
append-file $nvnNameTable "const size_t NvnFunctionCount = sizeof(gNvnFunctionNames) / sizeof(*gNvnFunctionNames);"
append-file $nvnNameTable "}}} // nn::profiler::nvn"

exit $LASTEXITCODE
