﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/prepo/detail/service/core/prepo_UserManager.h>
#include <nn/account.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

namespace
{
    bool GetUserExistence(const nn::account::Uid user) NN_NOEXCEPT
    {
        bool existence;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::account::GetUserExistence(&existence, user));
        return existence;
    }
}

UserManager::UserManager() NN_NOEXCEPT
{
    for (auto& user : m_Users)
    {
        user = nn::account::InvalidUid;
    }
};

void UserManager::Add(const nn::account::Uid& user) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(user, nn::account::InvalidUid);

    if (TryAdd(user))
    {
        return;
    }
    RemoveInexistenceUser();
    NN_ABORT_UNLESS(TryAdd(user));
}

void UserManager::RemoveIfContains(const nn::account::Uid& user) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(user, nn::account::InvalidUid);

    for (auto& addedUser : m_Users)
    {
        if (addedUser == user)
        {
            addedUser = nn::account::InvalidUid;
        }
    }
}

bool UserManager::Contains(const nn::account::Uid& user) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(user, nn::account::InvalidUid);

    for (auto addedUser : m_Users)
    {
        if (addedUser == user)
        {
            return true;
        }
    }
    return false;
}

bool UserManager::TryAdd(const nn::account::Uid& user) NN_NOEXCEPT
{
    if (Contains(user))
    {
        return true;
    }
    for (auto& addedUser : m_Users)
    {
        if (addedUser == nn::account::InvalidUid)
        {
            addedUser = user;
            return true;
        }
    }
    return false;
}

void UserManager::RemoveInexistenceUser() NN_NOEXCEPT
{
    for (auto& user : m_Users)
    {
        if (user != nn::account::InvalidUid)
        {
            if (!GetUserExistence(user))
            {
                user = nn::account::InvalidUid;
            }
        }
    }
}

}}}}}
