﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "perflog_CreateDaemon.h"

#include <nn/perflog/sfdl/perflog.sfdl.h>       // for sf::IDaemon
#include "perflog_ServiceName.h"                 // for PerflogDaemonServiceName
#include <nn/sf/sf_HipcClientProxyByName.h>     // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>          // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>


namespace nn { namespace perflog {

namespace {

// Prepare an allocator that uses the expanded heap for the HIPC proxy.
struct CreateDaemonByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateDaemonByHipcTag> MyAllocator;

// Helper to initialize MyAllocator with a static constructor.
class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<sf::IDaemon> CreateDaemonByHipc() NN_NOEXCEPT
{
    // Take the HIPC service object represented by SfsmplDaemonServiceName,
    // Create a proxy client as an sf::IDaemon and return it.
    // Pass MyAllocator::Policy as the allocation policy.
    nn::sf::SharedPointer<sf::IDaemon> ret;
    auto result = nn::sf::CreateHipcProxyByName<sf::IDaemon, MyAllocator::Policy>(&ret, PerflogDaemonServiceName);
    if( !result.IsSuccess() )
    {
        NN_SDK_LOG("ERROR: failed to create hipc proxy, module=%d/0x%x,  description=%d/0x%x\n",
            result.GetModule(), result.GetModule(), result.GetDescription(), result.GetDescription() );
    }
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}  // nn::perflog


