﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pdm/detail/pdm_Fs.h>
#include <nn/pdm/detail/pdm_Log.h>
#include <nn/pdm/detail/pdm_PlayEventBuffer.h>
#include <nn/pdm/detail/pdm_SaveDataCommitThread.h>
#include <nn/pdm/detail/pdm_Util.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_LockGuard.h>
#include <mutex>

namespace nn { namespace pdm { namespace detail {

namespace
{
    detail::InitializationManager g_Initialization = NN_PDM_INITIALIZATION_INITIALIZER;

    nn::Result MountSystemSaveData() NN_NOEXCEPT
    {
        NN_RESULT_TRY(nn::fs::MountSystemSaveData(MountName, SystemSaveDataId))
            NN_RESULT_CATCH(nn::fs::ResultTargetNotFound)
            {
                // pdm をホストするプロセスが ns から sdb に移行された。
                // 互換性維持のため、セーブデータの所有者は ns のままにする。
                NN_RESULT_DO(nn::fs::CreateSystemSaveData(SystemSaveDataId, 0x010000000000001F, SystemSaveDataSize, SystemSaveDataJournalSize, 0));
                NN_RESULT_DO(nn::fs::MountSystemSaveData(MountName, SystemSaveDataId));
            }
        NN_RESULT_END_TRY;
        NN_RESULT_SUCCESS;
    }
}

void InitializeFs() NN_NOEXCEPT
{
    g_Initialization.Initialize([]()
    {
#if defined( PDM_USE_HOST_FS )
        NN_ABORT_UNLESS_RESULT_SUCCESS(fs::MountHost(detail::MountName, detail::HostDirPath));
#else
        NN_ABORT_UNLESS_RESULT_SUCCESS(MountSystemSaveData());
#endif
        detail::PlayEventBuffer::GetInstance().Initialize();
    });
}

void FinalizeFs() NN_NOEXCEPT
{
    g_Initialization.Finalize([]()
    {
        fs::Unmount(detail::MountName);
    });
}

void CommitSaveData() NN_NOEXCEPT
{
    // Commit 時には全てのファイルが閉じられている必要があるのでロックしておく。
    NN_UTIL_LOCK_GUARD(PlayEventBuffer::GetInstance().GetFileMutex());
    NN_ABORT_UNLESS_RESULT_SUCCESS(fs::CommitSaveData(detail::MountName));
}

}}}
