﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

#include <nn/pcv/detail/pcv_IPcvService.h>
#include <nn/pcv/pcv_IArbitrationManager.sfdl.h>
#include <nn/pcv/pcv_IImmediateManager.sfdl.h>

namespace nn {
namespace pcv {
namespace server {

class PcvServiceImpl
{
public:
    nn::Result SetPowerEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
    nn::Result SetClockEnabled(std::int32_t moduleId, bool enabled) NN_NOEXCEPT;
    nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
    nn::Result GetClockRate(nn::sf::Out<std::uint32_t> pClockRateHz, std::int32_t moduleId) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<nn::pcv::ModuleState> pState, std::int32_t moduleId) NN_NOEXCEPT;
    nn::Result GetPossibleClockRates(nn::sf::Out<std::int32_t> pOutType,
                                     const nn::sf::OutArray<std::uint32_t>& pOutRates,
                                     nn::sf::Out<int> pOutCount, std::int32_t moduleId, int maxCount) NN_NOEXCEPT;
    nn::Result SetMinVClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
    nn::Result SetReset(std::int32_t moduleId, bool reset) NN_NOEXCEPT;
    nn::Result SetVoltageEnabled(std::int32_t powerDomain, bool enabled) NN_NOEXCEPT;
    nn::Result GetVoltageEnabled(nn::sf::Out<bool> pEnabled, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result GetVoltageRange(nn::sf::Out<nn::pcv::MicroVolt> pMinVolt, nn::sf::Out<nn::pcv::MicroVolt> pMaxVolt, nn::sf::Out<nn::pcv::MicroVolt> pStepVolt, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result SetVoltageValue(std::int32_t powerDomain, std::int32_t microVolt) NN_NOEXCEPT;
    nn::Result GetVoltageValue(nn::sf::Out<nn::pcv::MicroVolt> pMicroVolt, std::int32_t powerDomain) NN_NOEXCEPT;
    nn::Result GetTemperatureThresholds(const nn::sf::OutArray<TemperatureThreshold>& pThresholds,
                                    nn::sf::Out<int> pOutCount, int maxCount) NN_NOEXCEPT;
    nn::Result SetTemperature(std::int32_t temperatureMilliC) NN_NOEXCEPT;
    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result IsInitialized(nn::sf::Out<bool> pOutInitialized) NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
    nn::Result PowerOn(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT;
    nn::Result PowerOff(PowerControlTarget powerControlTarget) NN_NOEXCEPT;
    nn::Result ChangeVoltage(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT;
    nn::Result GetPowerClockInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetOscillatorClock(nn::sf::Out<std::uint32_t> pClockRateHz) NN_NOEXCEPT;
    nn::Result GetDvfsTable(const nn::sf::OutArray<std::uint32_t>& pOutClocks,
                            const nn::sf::OutArray<std::int32_t>& pOutVoltages,
                            nn::sf::Out<int32_t> pOutCount, std::int32_t moduleId, int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetModuleStateTable(const nn::sf::OutArray<nn::pcv::ModuleState>& pOutModuleStates,
                                   nn::sf::Out<int32_t> pOutCount, int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetPowerDomainStateTable(const nn::sf::OutArray<nn::pcv::PowerDomainState>& pOutPowerDomainStates,
                                        nn::sf::Out<int32_t> pOutCount, int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetFuseInfo(const nn::sf::OutArray<uint32_t>& pOutValues, nn::sf::Out<int32_t> pOutCount, int32_t maxCount) NN_NOEXCEPT;
    nn::Result GetDramId(const nn::sf::Out<uint32_t>& pOutDramId) NN_NOEXCEPT;
    nn::Result IsPoweredOn(nn::sf::Out<bool> pOutIsPoweredOn, PowerControlTarget powerControlTarget) NN_NOEXCEPT;
};

} // namespace server

class ImmediateManagerImpl
{
public:
    nn::Result SetClockRate(std::int32_t moduleId, std::uint32_t clockRateHz) NN_NOEXCEPT;
};

class ArbitrationManagerImpl
{
public:
    nn::Result ReleaseControl(std::int32_t moduleId) NN_NOEXCEPT;
};

} // namespace pcv
} // namespace nn
