﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pcv/driver/pcv.h>
#include <nn/pcv/driver/pcv_Suspend.h>

namespace nn {
namespace pcv {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

bool IsInitialized() NN_NOEXCEPT
{
    return true;
}

void Finalize() NN_NOEXCEPT
{
}

// TODO: Replace ResultSuccess() to NN_RESULT_SUCCESS
Result SetPowerEnabled(Module moduleId, bool enabled)  NN_NOEXCEPT
{
    NN_UNUSED(moduleId);
    NN_UNUSED(enabled);
    return ResultSuccess();
}

Result GetPossibleClockRates(ClockRatesListType* pOutType, ClockHz* pOutRates,
                             int* pOutCount, Module moduleId, int maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pOutType);
    NN_UNUSED(pOutRates);
    NN_UNUSED(pOutCount);
    NN_UNUSED(moduleId);
    NN_UNUSED(maxCount);
    return ResultSuccess();
}

Result SetClockEnabled(Module moduleId, bool enabled)  NN_NOEXCEPT
{
    NN_UNUSED(moduleId);
    NN_UNUSED(enabled);
    return ResultSuccess();
}

Result SetClockRate(Module moduleId, ClockHz clockRateHz)  NN_NOEXCEPT
{
    NN_UNUSED(moduleId);
    NN_UNUSED(clockRateHz);
    return ResultSuccess();
}

Result GetClockRate(ClockHz* pClockRateHz, Module moduleId) NN_NOEXCEPT
{
    NN_UNUSED(pClockRateHz);
    NN_UNUSED(moduleId);
    return ResultSuccess();
}

Result GetState(ModuleState *pState, Module moduleId) NN_NOEXCEPT
{
    NN_UNUSED(pState);
    NN_UNUSED(moduleId);
    return ResultSuccess();
}

Result SetMinVClockRate(Module moduleId, ClockHz clockRateHz) NN_NOEXCEPT
{
    NN_UNUSED(moduleId);
    NN_UNUSED(clockRateHz);
    return ResultSuccess();
}

Result SetReset(Module moduleId, bool asserted) NN_NOEXCEPT
{
    NN_UNUSED(moduleId);
    NN_UNUSED(asserted);
    return ResultSuccess();
}

Result SetVoltageEnabled(PowerDomain powerDomain, bool enabled) NN_NOEXCEPT
{
    NN_UNUSED(powerDomain);
    NN_UNUSED(enabled);
    return ResultSuccess();
}

Result GetVoltageEnabled(bool* pEnabled, PowerDomain powerDomain) NN_NOEXCEPT
{
    NN_UNUSED(pEnabled);
    NN_UNUSED(powerDomain);
    return ResultSuccess();
}

// Result GetPossibleVoltageValues(VoltageValuesListType* pOutType, MicroVolt* pOutValues,
//                                 int* pOutCount, PowerDomain powerDomain, int maxCount) NN_NOEXCEPT
// {
//     NN_UNUSED(pOutType);
//     NN_UNUSED(pOutValues);
//     NN_UNUSED(pOutCount);
//     NN_UNUSED(powerDomain);
//     NN_UNUSED(maxCount);
//     return ResultSuccess();
// }
Result GetVoltageRange(MicroVolt* pMinVolt, MicroVolt* pMaxVolt, MicroVolt* pStepVolt, PowerDomain powerDomain) NN_NOEXCEPT
{
    NN_UNUSED(pMinVolt);
    NN_UNUSED(pMaxVolt);
    NN_UNUSED(pStepVolt);
    NN_UNUSED(powerDomain);
    return ResultSuccess();
}

Result SetVoltageValue(PowerDomain powerDomain, MicroVolt microVolt) NN_NOEXCEPT
{
    NN_UNUSED(powerDomain);
    NN_UNUSED(microVolt);
    return ResultSuccess();
}

Result GetVoltageValue(MicroVolt* pMicroVolt, PowerDomain powerDomain) NN_NOEXCEPT
{
    NN_UNUSED(pMicroVolt);
    NN_UNUSED(powerDomain);
    return ResultSuccess();
}


Result GetTemperatureThresholds(TemperatureThreshold* pThresholds, int* pOutCount, int maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pThresholds);
    NN_UNUSED(pOutCount);
    NN_UNUSED(maxCount);
    return ResultSuccess();
}

Result SetTemperature(MilliC temperatureMilliC) NN_NOEXCEPT
{
    NN_UNUSED(temperatureMilliC);
    return ResultSuccess();
}
Result SuspendClocks() NN_NOEXCEPT
{
    return ResultSuccess();
}

Result ResumeClocks() NN_NOEXCEPT
{
    return ResultSuccess();
}

Result SuspendVoltage() NN_NOEXCEPT
{
    return ResultSuccess();
}

Result ResumeVoltage() NN_NOEXCEPT
{
    return ResultSuccess();
}

Result PowerOn(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT
{
    NN_UNUSED(powerControlTarget);
    NN_UNUSED(microVolt);
    return ResultSuccess();
}

Result PowerOff(PowerControlTarget powerControlTarget) NN_NOEXCEPT
{
    NN_UNUSED(powerControlTarget);
    return ResultSuccess();
}

Result ChangeVoltage(PowerControlTarget powerControlTarget, MicroVolt microVolt) NN_NOEXCEPT
{
    NN_UNUSED(powerControlTarget);
    NN_UNUSED(microVolt);
    return ResultSuccess();
}

Result IsPoweredOn(bool* pOutIsPoweredOn, PowerControlTarget powerControlTarget) NN_NOEXCEPT
{
    NN_UNUSED(pOutIsPoweredOn);
    NN_UNUSED(powerControlTarget);
    return ResultSuccess();
}

nn::os::SystemEventType* GetPowerClockInfoEvent() NN_NOEXCEPT
{
    return nullptr;
}

uint32_t GetOscillatorClock() NN_NOEXCEPT
{
    return 0;
}

Result GetDvfsTable(uint32_t* pOutClocks, int32_t* pOutVoltages, int32_t* pOutCount, Module moduleId, int32_t maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pOutClocks);
    NN_UNUSED(pOutVoltages);
    NN_UNUSED(pOutCount);
    NN_UNUSED(moduleId);
    NN_UNUSED(maxCount);
    return ResultSuccess();
}

void GetModuleStateTable(ModuleState* pOutModuleStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pOutModuleStates);
    NN_UNUSED(pOutCount);
    NN_UNUSED(maxCount);
}

void GetPowerDomainStateTable(PowerDomainState* pOutPowerDomainStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pOutPowerDomainStates);
    NN_UNUSED(pOutCount);
    NN_UNUSED(maxCount);
}

void GetFuseInfo(uint32_t* pOutValues, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT
{
    NN_UNUSED(pOutValues);
    NN_UNUSED(pOutCount);
    NN_UNUSED(maxCount);
}

} // namespace driver
} // namespace pcv
} // namespace nn
