﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>

#include <nn/nn_Common.h>

#include <nn/pcv/pcv_Modules.h>

#include <nne/vcc/ipids.h>

namespace {

const std::pair<nn::pcv::Module, ::IP> ModuleIpPairs[] =
{
    { nn::pcv::Module_Cpu,               IP_CPU },
    { nn::pcv::Module_Gpu,               IP_GPU },
    { nn::pcv::Module_I2s1,              IP_I2S1 },
    { nn::pcv::Module_I2s2,              IP_I2S2 },
    { nn::pcv::Module_I2s3,              IP_I2S3 },
    { nn::pcv::Module_Pwm,               IP_PWM },
    { nn::pcv::Module_I2c1,              IP_I2C1 },
    { nn::pcv::Module_I2c2,              IP_I2C2 },
    { nn::pcv::Module_I2c3,              IP_I2C3 },
    { nn::pcv::Module_I2c4,              IP_I2C4 },
    { nn::pcv::Module_I2c5,              IP_I2C5 },
    { nn::pcv::Module_I2c6,              IP_I2C6 },
    { nn::pcv::Module_Spi1,              IP_SPI1 },
    { nn::pcv::Module_Spi2,              IP_SPI2 },
    { nn::pcv::Module_Spi3,              IP_SPI3 },
    { nn::pcv::Module_Spi4,              IP_SPI4 },
    { nn::pcv::Module_Disp1,             IP_DISP1 },
    { nn::pcv::Module_Disp2,             IP_DISP2 },
    { nn::pcv::Module_Isp,               IP_ISP },
    { nn::pcv::Module_Vi,                IP_VI },
    { nn::pcv::Module_Sdmmc1,            IP_SDMMC1 },
    { nn::pcv::Module_Sdmmc2,            IP_SDMMC2 },
    { nn::pcv::Module_Sdmmc3,            IP_SDMMC3 },
    { nn::pcv::Module_Sdmmc4,            IP_SDMMC4 },
    { nn::pcv::Module_Owr,               IP_OWR },
    { nn::pcv::Module_Csite,             IP_CSITE },
    { nn::pcv::Module_Tsec,              IP_TSEC },
    { nn::pcv::Module_Mselect,           IP_MSELECT },
    { nn::pcv::Module_Hda2codec2x,       IP_HDA2CODEC_2X },
    { nn::pcv::Module_Actmon,            IP_ACTMON },
    { nn::pcv::Module_I2cSlow,           IP_I2C_SLOW },
    { nn::pcv::Module_Sor1,              IP_SOR1 },
    { nn::pcv::Module_Sata,              IP_SATA },
    { nn::pcv::Module_Hda,               IP_HDA },
    { nn::pcv::Module_XusbCoreHostSrc,   IP_XUSB_CORE_HOST_SRC },
    { nn::pcv::Module_XusbFalconSrc,     IP_XUSB_FALCON_SRC },
    { nn::pcv::Module_XusbFsSrc,         IP_XUSB_FS_SRC },
    { nn::pcv::Module_XusbCoreDevSrc,    IP_XUSB_CORE_DEV_SRC },
    { nn::pcv::Module_XusbSsSrc,         IP_XUSB_SS_SRC },
    { nn::pcv::Module_UartA,             IP_UARTA },
    { nn::pcv::Module_UartB,             IP_UARTB },
    { nn::pcv::Module_UartC,             IP_UARTC },
    { nn::pcv::Module_UartD,             IP_UARTD },
    { nn::pcv::Module_Hostx,             IP_HOST1X },
    { nn::pcv::Module_Entropy,           IP_ENTROPY },
    { nn::pcv::Module_SocTherm,          IP_SOC_THERM },
    { nn::pcv::Module_Vic,               IP_VIC },
    { nn::pcv::Module_Nvenc,             IP_NVENC },
    { nn::pcv::Module_Nvjpg,             IP_NVJPG },
    { nn::pcv::Module_Nvdec,             IP_NVDEC },
    { nn::pcv::Module_Qspi,              IP_QSPI },
    { nn::pcv::Module_ViI2c,             IP_VI_I2C },
    { nn::pcv::Module_Tsecb,             IP_TSECB },
    { nn::pcv::Module_Ape,               IP_APE },
    { nn::pcv::Module_AudioDsp,          IP_AUDIO_DSP },
    { nn::pcv::Module_AudioUart,         IP_AUDIO_UART },
    { nn::pcv::Module_Emc,               IP_EMC },
    { nn::pcv::Module_Plle,              IP_PLLE },
    { nn::pcv::Module_PlleHwSeq,         IP_PLLE_HW_SEQ },
    { nn::pcv::Module_Dsi,               IP_DSI },
    { nn::pcv::Module_Maud,              IP_MAUD },
    { nn::pcv::Module_Dpaux1,            IP_DPAUX1 },
    { nn::pcv::Module_MipiCal,           IP_MIPI_CAL },
    { nn::pcv::Module_UartFstMipiCal,    IP_UART_FST_MIPI_CAL },
    { nn::pcv::Module_Osc,               IP_OSC },
    { nn::pcv::Module_SysBus,            IP_SYS_BUS },
    { nn::pcv::Module_SorSafe,           IP_SOR_SAFE },
    { nn::pcv::Module_XusbSs,            IP_XUSB_SS },
    { nn::pcv::Module_XusbHost,          IP_XUSB_HOST },
    { nn::pcv::Module_XusbDevice,        IP_XUSB_DEVICE },
    { nn::pcv::Module_Extperiph1,        IP_EXTPERIPH1 },
    { nn::pcv::Module_Ahub,              IP_AHUB },
    { nn::pcv::Module_Hda2hdmicodec,     IP_HDA2HDMICODEC },
    { nn::pcv::Module_Gpuaux,            IP_GPUAUX },
    { nn::pcv::Module_UsbD,              IP_USBD },
    { nn::pcv::Module_Usb2,              IP_USB2 },
    { nn::pcv::Module_Pcie,              IP_PCIE },
    { nn::pcv::Module_Afi,               IP_AFI },
    { nn::pcv::Module_PciExClk,          IP_PCIEXCLK },
    { nn::pcv::Module_PExUsbPhy,         IP_PEXUPHY },
    { nn::pcv::Module_XUsbPadCtl,        IP_XPADCTL },
    { nn::pcv::Module_Apbdma,            IP_APBDMA },
    { nn::pcv::Module_Usb2TrkClk,        IP_USB2TRK },
    { nn::pcv::Module_XUsbIoPll,         IP_XUSBIOPLL },
    { nn::pcv::Module_XUsbIoPllHwSeq,    IP_XUSBIOPLL_HW_SEQ },
    { nn::pcv::Module_Cec,               IP_CEC },
};

} // namespace
