﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

[AttributeUsage(AttributeTargets.Struct | AttributeTargets.Parameter, AllowMultiple = true)]
class NonNegativeAttribute : PreAttribute
{
    public NonNegativeAttribute() : base("_ >= 0") { }
}

[AttributeUsage(AttributeTargets.Struct | AttributeTargets.Parameter, AllowMultiple = true)]
class ValidApplicationIdAttribute : PreAttribute
{
    public ValidApplicationIdAttribute() : base("_ != nn::ncm::ApplicationId::GetInvalidId()") { }
}

[AttributeUsage(AttributeTargets.Struct | AttributeTargets.Parameter, AllowMultiple = true)]
class ValidSafetyLevelAttribute : PreAttribute
{
    // 5 == nn::pctl::SafetyLevel_Max
    public ValidSafetyLevelAttribute() : base("_ >= 0 && _ < 5") { }
}

namespace nn
{
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpanType
    {
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.time
{
    [CppRefPath(@"<nn/time/time_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct PosixTime
    {
    }
}

namespace nn.pctl
{
    [CppRefPath(@"<nn/pctl/pctl_TypesSystem.h>")]
    [ExternalStruct(3, 1)]
    public struct SafetyLevelSettings
    {
    }

    [CppRefPath(@"<nn/pctl/pctl_TypesSystem.h>")]
    [ExternalStruct(16, 8)]
    public struct FreeCommunicationApplicationInfo
    {
    }

    [CppRefPath(@"<nn/pctl/pctl_TypesSystem.h>")]
    [ExternalStruct(16, 8)]
    public struct ExemptApplicationInfo
    {
    }

    [CppRefPath(@"<nn/pctl/pctl_TypesForAuthentication.h>")]
    [ExternalStruct(32, 1)]
    public struct InquiryCode
    {
    }

    [CppRefPath(@"<nn/pctl/pctl_TypesWatcher.h>")]
    [ExternalStruct(52, 2)]
    public struct PlayTimerSettings
    {
    }
}

namespace nn.pctl.detail
{
    [CppRefPath(@"<nn/pctl/detail/pctl_PairingInfoBase.h>")]
    [ExternalStruct(16, 8)]
    public struct PairingInfoBase
    {
    }

    [CppRefPath(@"<nn/pctl/detail/pctl_PairingInfoBase.h>")]
    [ExternalStruct(16, 8)]
    public struct PairingAccountInfoBase
    {
    }

    [CppRefPath(@"<nn/pctl/detail/pctl_AsyncData.h>")]
    [ExternalStruct(8, 4)]
    public struct AsyncData
    {
    }
}

namespace nn.pctl.detail.service.watcher
{
    [CppRefPath(@"<nn/pctl/detail/service/watcher/pctl_EventLog.h>")]
    [ExternalStruct(96, 8)]
    public struct EventData
    {
    }
}

namespace nn.pctl.detail.ipc
{
    [CppRefPath(@"<nn/pctl/detail/ipc/pctl_IParentalControlService.sfdl.h>")]
    public partial interface IParentalControlService : IServiceObject { }
    [CppRefPath(@"<nn/pctl/detail/ipc/pctl_IParentalControlServiceFactory.sfdl.h>")]
    public partial interface IParentalControlServiceFactory : IServiceObject { }

    //// IParentalControlService

    public partial interface IParentalControlService
    {
        [MethodId(1)]
        Result Initialize();
    }

    // ペアコン状態チェック関数(ID: 1001-1030 ※ デバッグ用は1901-)
    public partial interface IParentalControlService
    {
        [MethodId(1001)]
        Result CheckFreeCommunicationPermission();

        [MethodId(1002)]
        Result ConfirmLaunchApplicationPermission([ValidApplicationId] nn.ncm.ApplicationId applicationId, InArray<int8_t> ratingAge, bool freeCommunicationFlag);

        [MethodId(1003)]
        Result ConfirmResumeApplicationPermission([ValidApplicationId] nn.ncm.ApplicationId applicationId, InArray<int8_t> ratingAge, bool freeCommunicationFlag);

        [MethodId(1004)]
        Result ConfirmSnsPostPermission();

        [MethodId(1005)]
        Result ConfirmSystemSettingsPermission();

        [MethodId(1006)]
        Result IsRestrictionTemporaryUnlocked(Out<bool> outValue);

        [MethodId(1007)]
        Result RevertRestrictionTemporaryUnlocked();

        [MethodId(1008)]
        Result EnterRestrictedSystemSettings();

        [MethodId(1009)]
        Result LeaveRestrictedSystemSettings();

        [MethodId(1010)]
        Result IsRestrictedSystemSettingsEntered(Out<bool> outValue);

        [MethodId(1011)]
        Result RevertRestrictedSystemSettingsEntered();

        [MethodId(1012)]
        Result GetRestrictedFeatures(Out<int_t> outFeatures);

        // 1013 --> ConfirmStereoVisionPermission

        [MethodId(1014)]
        Result ConfirmPlayableApplicationVideoOld(InArray<int8_t> ratingAge);

        [MethodId(1015)]
        Result ConfirmPlayableApplicationVideo([ValidApplicationId] nn.ncm.ApplicationId applicationId, InArray<int8_t> ratingAge);
    }

    // ペアコン設定変更関数(ID: 1031-1060 ※ デバッグ用は1901-)
    public partial interface IParentalControlService
    {
        [MethodId(1031)]
        Result IsRestrictionEnabled(Out<bool> outValue);

        [MethodId(1032)]
        Result GetSafetyLevel(Out<int_t> outSafetyLevel);

        [MethodId(1033)]
        Result SetSafetyLevel([ValidSafetyLevel] int_t level);

        [MethodId(1034)]
        Result GetSafetyLevelSettings(Out<SafetyLevelSettings> pSettings, [ValidSafetyLevel] int_t level);

        [MethodId(1035)]
        Result GetCurrentSettings(Out<SafetyLevelSettings> pSettings);

        [MethodId(1036)]
        Result SetCustomSafetyLevelSettings(SafetyLevelSettings pSettings);

        [MethodId(1037)]
        Result GetDefaultRatingOrganization(Out<int_t> outOrganization);

        [MethodId(1038)]
        Result SetDefaultRatingOrganization([NonNegative] int_t organization);

        [MethodId(1039)]
        Result GetFreeCommunicationApplicationListCount(Out<int_t> outCount);

        // removed: MethodId(1040)
        // removed: MethodId(1041)

        [MethodId(1042)]
        Result AddToFreeCommunicationApplicationList([ValidApplicationId] nn.ncm.ApplicationId applicationId);

        [MethodId(1043)]
        Result DeleteSettings();

        [MethodId(1044)]
        Result GetFreeCommunicationApplicationList(
            Out<int_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<FreeCommunicationApplicationInfo> pOutTitleInfoArray,
            [NonNegative] int_t offset
            );

        [MethodId(1045)]
        Result UpdateFreeCommunicationApplicationList(
            [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<FreeCommunicationApplicationInfo> pTitleInfoArray
            );

        [MethodId(1046)]
        Result DisableFeaturesForReset();

        [MethodId(1047)]
        Result NotifyApplicationDownloadStarted([ValidApplicationId] nn.ncm.ApplicationId applicationId);

        // Debug

        [MethodId(1901)]
        Result DeleteFromFreeCommunicationApplicationListForDebug([ValidApplicationId] nn.ncm.ApplicationId applicationId);

        [MethodId(1902)]
        Result ClearFreeCommunicationApplicationListForDebug();

        [MethodId(1903)]
        Result GetExemptApplicationListCountForDebug(Out<int_t> outCount);

        [MethodId(1904)]
        Result GetExemptApplicationListForDebug(
            Out<int_t> outCount,
            [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ExemptApplicationInfo> pOutTitleInfoArray,
            [NonNegative] int_t offset
            );

        [MethodId(1905)]
        Result UpdateExemptApplicationListForDebug(
            [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ExemptApplicationInfo> pTitleInfoArray
            );

        [MethodId(1906)]
        Result AddToExemptApplicationListForDebug([ValidApplicationId] nn.ncm.ApplicationId applicationId);

        [MethodId(1907)]
        Result DeleteFromExemptApplicationListForDebug([ValidApplicationId] nn.ncm.ApplicationId applicationId);

        [MethodId(1908)]
        Result ClearExemptApplicationListForDebug();
    }

    // StereoVision関連関数(ID: 1013,1061-1080 ※ デバッグ用は1901-)
    public partial interface IParentalControlService
    {
        [MethodId(1013)]
        Result ConfirmStereoVisionPermission();

        [MethodId(1061)]
        Result ConfirmStereoVisionRestrictionConfigurable();

        [MethodId(1062)]
        Result GetStereoVisionRestriction(Out<bool> outRestricted);

        [MethodId(1063)]
        Result SetStereoVisionRestriction(bool restricted);

        [MethodId(1064)]
        Result ResetConfirmedStereoVisionPermission();

        [MethodId(1065)]
        Result IsStereoVisionPermitted(Out<bool> outValue);
    }

    // 解除コード・マスターキー処理関連関数(ID: 1201-1220 ※ デバッグ用は1901-)
    public partial interface IParentalControlService
    {
        [MethodId(1201)]
        Result UnlockRestrictionTemporarily(InArray<char_t> code);

        [MethodId(1202)]
        Result UnlockSystemSettingsRestriction(InArray<char_t> code);

        [MethodId(1203)]
        Result SetPinCode(InArray<char_t> code);

        [MethodId(1204)]
        Result GenerateInquiryCode(Out<InquiryCode> pOutCodeData);

        [MethodId(1205)]
        Result CheckMasterKey(Out<bool> outValue, InquiryCode codeData, InArray<char_t> masterKey);

        [MethodId(1206)]
        Result GetPinCodeLength(Out<int_t> outValue);

        [MethodId(1207)]
        Result GetPinCodeChangedEvent(Out<NativeHandle> pEvent);

        [MethodId(1208)]
        Result GetPinCode(Out<int_t> outLength, OutArray<char_t> outCode);
    }

    // サーバー連携処理関数(ID: 1401-1430 ※ デバッグ用は1951-)
    public partial interface IParentalControlService
    {
        // removed: MethodId(1401)

        // removed: MethodId(1402)

        [MethodId(1403)]
        Result IsPairingActive(Out<bool> outValue);

        // removed: MethodId(1404)

        // removed: MethodId(1405)

        [MethodId(1406)]
        Result GetSettingsLastUpdated(Out<nn.time.PosixTime> outValue);

        [MethodId(1941)]
        Result DeletePairing();

        // PairingInfo / PairingAccountInfo 用メソッド

        [MethodId(1411)]
        Result GetPairingAccountInfo(Out<PairingAccountInfoBase> pAccountInfo, PairingInfoBase pairingInfo);

        [MethodId(1421)]
        Result GetAccountNickname(Out<uint32_t> pActualSize, OutArray<char_t> pNickname, PairingAccountInfoBase accountInfo);

        // removed: MethodId(1422)

        // removed: MethodId(1423)

        [MethodId(1424)]
        Result GetAccountState(Out<int_t> outState, PairingAccountInfoBase accountInfo);

        [MethodId(1425)]
        Result RequestPostEvents(Out<int_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<service.watcher.EventData> outEventDataArray);
    }

    // 同期処理関数(ID: 1431-1450 ※ デバッグ用は1951-)
    public partial interface IParentalControlService
    {
        // removed: MethodId(1431)

        [MethodId(1432)]
        Result GetSynchronizationEvent(Out<NativeHandle> pEvent);
    }

    // プレイタイマー処理関数(ID: 1451-1470 ※ デバッグ用は1951-)
    public partial interface IParentalControlService
    {
        [MethodId(1451)]
        Result StartPlayTimer();

        [MethodId(1452)]
        Result StopPlayTimer();

        [MethodId(1453)]
        Result IsPlayTimerEnabled(Out<bool> outValue);

        [MethodId(1454)]
        Result GetPlayTimerRemainingTime(Out<nn.TimeSpanType> outTime);

        [MethodId(1455)]
        Result IsRestrictedByPlayTimer(Out<bool> outValue);

        [MethodId(1456)]
        Result GetPlayTimerSettings(Out<PlayTimerSettings> pSettings);

        [MethodId(1457)]
        Result GetPlayTimerEventToRequestSuspension(Out<NativeHandle> pEvent);

        [MethodId(1458)]
        Result IsPlayTimerAlarmDisabled(Out<bool> outValue);

        [MethodId(1951)]
        Result SetPlayTimerSettingsForDebug(PlayTimerSettings settings);

        [MethodId(1952)]
        Result GetPlayTimerSpentTimeForTest(Out<nn.TimeSpanType> outTime);

        [MethodId(1953)]
        Result SetPlayTimerAlarmDisabledForDebug(bool isDisabled);
    }

    // その他のサーバー連携関連関数(ID: 1471-1500 ※ デバッグ用は1951-)
    public partial interface IParentalControlService
    {
        [MethodId(1471)]
        Result NotifyWrongPinCodeInputManyTimes();

        [MethodId(1472)]
        Result CancelNetworkRequest();

        [MethodId(1473)]
        Result GetUnlinkedEvent(Out<NativeHandle> pEvent);

        [MethodId(1474)]
        Result ClearUnlinkedEvent();
    }

    // 修理・修復ツール向けペアレンタルコントロール処理関数(ID: 1601-1700 ※ デバッグ用は1981-)
    public partial interface IParentalControlService
    {
        [MethodId(1601)]
        Result DisableAllFeatures(Out<bool> outIsAlreadyDisabled);

        [MethodId(1602)]
        Result PostEnableAllFeatures(Out<bool> outIsAlreadyEnabled);

        [MethodId(1603)]
        Result IsAllFeaturesDisabled(Out<bool> outValue, Out<bool> outIsEnabledOnNextBoot);
    }

    // サーバー連携処理関数の非同期処理版(ID: 2001-2100 ※ デバッグ用は2901-)
    public partial interface IParentalControlService
    {
        [MethodId(2001)]
        Result RequestPairingAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, InArray<char_t> code);

        [MethodId(2002)]
        Result FinishRequestPairing(Out<PairingInfoBase> pInfo, AsyncData asyncData);

        [MethodId(2003)]
        Result AuthorizePairingAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, PairingInfoBase pairingInfo);

        [MethodId(2004)]
        Result FinishAuthorizePairing(Out<PairingInfoBase> pUpdatedInfo, AsyncData asyncData);

        [MethodId(2005)]
        Result RetrievePairingInfoAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent);

        [MethodId(2006)]
        Result FinishRetrievePairingInfo(Out<PairingInfoBase> pInfo, AsyncData asyncData);

        [MethodId(2007)]
        Result UnlinkPairingAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, bool force);

        [MethodId(2008)]
        Result FinishUnlinkPairing(AsyncData asyncData, bool force);

        [MethodId(2009)]
        Result GetAccountMiiImageAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, Out<uint32_t> pActualSize, OutBuffer pImage, PairingAccountInfoBase accountInfo);

        [MethodId(2010)]
        Result FinishGetAccountMiiImage(Out<uint32_t> pActualSize, OutBuffer pImage, AsyncData asyncData);

        [MethodId(2011)]
        Result GetAccountMiiImageContentTypeAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, Out<uint32_t> pActualLength, OutArray<char_t> pContentType, PairingAccountInfoBase accountInfo);

        [MethodId(2012)]
        Result FinishGetAccountMiiImageContentType(Out<uint32_t> pActualLength, OutArray<char_t> pContentType, AsyncData asyncData);

        [MethodId(2013)]
        Result SynchronizeParentalControlSettingsAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent);

        // deprecated
        [MethodId(2014)]
        Result FinishSynchronizeParentalControlSettings(AsyncData asyncData);

        [MethodId(2015)]
        Result FinishSynchronizeParentalControlSettingsWithLastUpdated(Out<nn.time.PosixTime> outLastUpdated, AsyncData asyncData);

        [MethodId(2016)]
        Result RequestUpdateExemptionListAsync(Out<AsyncData> pAsyncData, Out<NativeHandle> pEvent, [ValidApplicationId] nn.ncm.ApplicationId applicationId, bool isExempt);
    }

    //// IParentalControlServiceFactory

    public partial interface IParentalControlServiceFactory
    {
        [MethodId(0)]
        Result CreateService(Out<IParentalControlService> outService, [ProcessId] nn.Bit64 processId);

        [MethodId(1)]
        Result CreateServiceWithoutInitialize(Out<IParentalControlService> outService, [ProcessId] nn.Bit64 processId);
    }
}
