﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/pctl/pctl_ApiSystemReadOnly.h>
#include <nn/pctl/detail/pctl_ResultHandler.h>
#include <nn/pctl/detail/ipc/pctl_IpcSession.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl {

// 本体機能向けペアコン状態取得関数

nn::Result ConfirmSystemSettingsPermission() NN_NOEXCEPT
{
    auto result = detail::ipc::GetService()->ConfirmSystemSettingsPermission();
    NN_PCTL_DETAIL_ABORT_IF_UNEXPECTED_RESULT(result);

    return result;
}

bool IsRestrictionTemporaryUnlocked() NN_NOEXCEPT
{
    bool value = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->IsRestrictionTemporaryUnlocked(&value));
    return value;
}

bool IsRestrictedSystemSettingsEntered() NN_NOEXCEPT
{
    bool value = false;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->IsRestrictedSystemSettingsEntered(&value));
    return value;
}

Feature GetRestrictedFeatures() NN_NOEXCEPT
{
    int value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetService()->GetRestrictedFeatures(&value));
    return static_cast<Feature>(value);
}

nn::Result ConfirmPlayableApplicationVideo(nn::ncm::ApplicationId applicationId, const int8_t (&ratingAge)[32]) NN_NOEXCEPT
{
    // いったん配列にコピー
    int8_t tempArray[32];
    std::memcpy(tempArray, ratingAge, sizeof(ratingAge));
    nn::sf::InArray<int8_t> inArray(tempArray, std::extent<decltype(tempArray)>::value);

    auto result = detail::ipc::GetService()->ConfirmPlayableApplicationVideo(applicationId, inArray);
    NN_PCTL_DETAIL_ABORT_IF_UNEXPECTED_RESULT(result);

    return result;
}

// 本体機能向けプレイタイマー状態取得関数

bool IsPlayTimerEnabled() NN_NOEXCEPT
{
    bool value;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetServiceForWatcher()->IsPlayTimerEnabled(&value));
    return value;
}

nn::TimeSpan GetPlayTimerRemainingTime() NN_NOEXCEPT
{
    nn::TimeSpanType value;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::GetServiceForWatcher()->GetPlayTimerRemainingTime(&value));
    return nn::TimeSpan(value);
}

}}
