﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_IntermittentOperation.h>

#include <nn/pctl/detail/pctl_Log.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

// static
nn::Result IntermittentOperation::NotifyTaskStarting() NN_NOEXCEPT
{
    // ライブラリのリンクの関係上ここでは bgtc を使わない
    NN_DETAIL_PCTL_TRACE("[pctl] Intermittent operation starting...\n");
    return nn::ResultSuccess();
}

// static
void IntermittentOperation::NotifyTaskFinished() NN_NOEXCEPT
{
    NN_DETAIL_PCTL_TRACE("[pctl] Intermittent operation finishing...\n");
}

// static
bool IntermittentOperation::IsInHalfAwake() NN_NOEXCEPT
{
    return false;
}

// static
void IntermittentOperation::ScheduleTask() NN_NOEXCEPT
{
    // do nothing
}

}}}}}
