﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/init.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceMemoryManagement.h>
#include <cstdlib>

#if NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS != NN_DETAIL_PCTL_CONFIG_SERVER_PROCESS_HIPC
#error Unexpected configuration (HIPC mode is expected for horizon)
#endif

namespace nn { namespace pctl { namespace detail { namespace service {

namespace
{
    // 概算メモ:
    //  - 256KiB
    //    - libcurl は同時利用で約220KiB程度消費する
    //  - 384KiB
    //    - Device Playerリソースの更新時に 128KiB のデータを Base64 で送信する(ワークバッファーも必要)
    //      - 128KiB のデータ自体は Base64 に変換後不要になるので、バッファーは2つで良い
    //    - 384KiB = 192KiB * 2 (ぎりぎり値は約 342KiB (349528 : 2 * (128KiB / 3 * 4)))
    //  - 64KiB
    //    - 残りの雑多なメモリ割り当て(以前は common::NetworkBuffer 用も含む)
    //  → 768KiB 確保とする
    // ※ 2.1.0NUP 時点では合計を「512KiB (384KiB でも足りる？)」としていた
    // ※ pctlスレッドのスタックバッファーは別途固定領域を確保
    NN_ALIGNAS(4096) nn::Bit8 g_Heap[768 * 1024];
}

void InitializeAllocatorForServer() NN_NOEXCEPT
{
    nn::init::InitializeAllocator(g_Heap, sizeof(g_Heap));
}

void* AllocateMemoryBlock(size_t size) NN_NOEXCEPT
{
    return malloc(size);
}

void* AllocateMemoryBlock(size_t size, size_t alignment) NN_NOEXCEPT
{
    return aligned_alloc(alignment, size);
}

void FreeMemoryBlock(void* block) NN_NOEXCEPT
{
    free(block);
}

}}}}
